package com.sinosoftgz.starter.session.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;


/**
 * Created by Roney on 2021/1/14 10:59.
 */
@Configuration
@EnableConfigurationProperties({ServerProperties.class})
@EnableRedisHttpSession(redisFlushMode = RedisFlushMode.IMMEDIATE)
public class SessionConfiguration {

    private static final String domainNamePattern = "^.+?\\.(\\w+\\.[a-z]+)$";

    @Bean
    @ConditionalOnMissingBean
    public CookieSerializer cookieSerializer(ServerProperties serverProperties) {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(serverProperties.getServlet().getSession().getCookie().getName());
        serializer.setCookiePath(serverProperties.getServlet().getSession().getCookie().getPath());
        serializer.setDomainName(serverProperties.getServlet().getSession().getCookie().getDomain());
        if (serverProperties.getServlet().getSession().getCookie().getSecure() != null) {
            serializer.setUseSecureCookie(serverProperties.getServlet().getSession().getCookie().getSecure());
        }
        serializer.setDomainNamePattern(domainNamePattern);
        return serializer;
    }

    @Bean
    public ConfigureRedisAction configureRedisAction() {
        return ConfigureRedisAction.NO_OP;
    }
}
