/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.swagger.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.sinosoftgz.starter.swagger.properties.Swagger2Properties;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConditionalOnClass(value={EnableSwagger2.class})
@ConditionalOnProperty(prefix="swagger", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={Swagger2Properties.class})
public class SwaggerConfiguration {
    private static final String SPLITOR = ",";
    @Autowired
    Swagger2Properties swagger2Properties;

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(this.basePackage(this.swagger2Properties.getBasePackage())).apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swagger2Properties.getTitle()).description(this.swagger2Properties.getDescription()).termsOfServiceUrl(this.swagger2Properties.getTermsOfServiceUrl()).version(this.swagger2Properties.getVersion()).contact(this.swagger2Properties.getContact()).build();
    }

    private Predicate<RequestHandler> basePackage(String basePackage) {
        return input -> (Boolean)this.declaringClass((RequestHandler)input).transform(this.handlerPackage(basePackage)).or((Object)true);
    }

    private Function<Class<?>, Boolean> handlerPackage(String basePackage) {
        return input -> {
            for (String strPackage : basePackage.split(SPLITOR)) {
                boolean isMatch = input.getPackage().getName().startsWith(strPackage);
                if (!isMatch) continue;
                return true;
            }
            return false;
        };
    }

    private Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.fromNullable((Object)input.declaringClass());
    }
}

