/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.swagger.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sinosoftgz.starter.swagger.model.ModelAttr;
import com.sinosoftgz.starter.swagger.model.Request;
import com.sinosoftgz.starter.swagger.model.Response;
import com.sinosoftgz.starter.swagger.model.Table;
import com.sinosoftgz.starter.swagger.service.WordService;
import com.sinosoftgz.starter.swagger.utils.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class WordServiceImpl
implements WordService {
    private static final Logger log = LoggerFactory.getLogger(WordServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;

    @Override
    public Map<String, Object> tableList(String swaggerUrl) {
        Map<String, Object> resultMap = new ConcurrentHashMap<String, Object>();
        try {
            String jsonStr = (String)this.restTemplate.getForObject(swaggerUrl, String.class, new Object[0]);
            resultMap = this.tableListFromString(jsonStr);
        }
        catch (Exception e) {
            log.error("parse error", (Throwable)e);
        }
        return resultMap;
    }

    private Map<String, Object> tableListFromString(String jsonStr) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Table> result = new ArrayList<Table>();
        try {
            Map<String, Object> map = this.getResultFromString(result, jsonStr);
            Map<String, List<Table>> tableMap = ((Stream)result.stream().parallel()).collect(Collectors.groupingBy(Table::getTitle));
            resultMap.put("tableMap", new TreeMap<String, List<Table>>(tableMap));
            resultMap.put("info", map.get("info"));
        }
        catch (Exception e) {
            log.error("parse error", (Throwable)e);
        }
        return resultMap;
    }

    private Map<String, Object> getResultFromString(List<Table> result, String jsonStr) throws IOException {
        Map map = JsonUtils.readValue(jsonStr, HashMap.class);
        Map<String, ModelAttr> definitinMap = this.parseDefinitions(map);
        Map paths = (Map)map.get("paths");
        if (paths != null) {
            for (Map.Entry path : paths.entrySet()) {
                Iterator it2 = ((Map)path.getValue()).entrySet().iterator();
                String url = (String)path.getKey();
                while (it2.hasNext()) {
                    Map.Entry request = it2.next();
                    String requestType = (String)request.getKey();
                    Map content = (Map)request.getValue();
                    String title = String.valueOf(((List)content.get("tags")).get(0));
                    String tag = String.valueOf(content.get("summary"));
                    String description = String.valueOf(content.get("summary"));
                    String requestForm = "";
                    List consumes = (List)content.get("consumes");
                    if (consumes != null && consumes.size() > 0) {
                        requestForm = StringUtils.join((Iterable)consumes, (String)",");
                    }
                    String responseForm = "";
                    List produces = (List)content.get("produces");
                    if (produces != null && produces.size() > 0) {
                        responseForm = StringUtils.join((Iterable)produces, (String)",");
                    }
                    ArrayList parameters = (ArrayList)content.get("parameters");
                    LinkedHashMap responses = (LinkedHashMap)content.get("responses");
                    Table table = this.processTable(definitinMap, url, requestType, title, tag, description, requestForm, responseForm, parameters, responses);
                    Map obj = (Map)responses.get("200");
                    if (obj != null && obj.get("schema") != null) {
                        table.setModelAttr(this.processResponseModelAttrs(obj, definitinMap));
                    }
                    table.setRequestParam(this.processRequestParam(table.getRequestList()));
                    table.setResponseParam(this.processResponseParam(obj, definitinMap));
                    result.add(table);
                }
            }
        }
        return map;
    }

    private Table processTable(Map<String, ModelAttr> definitinMap, String url, String requestType, String title, String tag, String description, String requestForm, String responseForm, List<LinkedHashMap> parameters, Map<String, Object> responses) {
        Table table = new Table();
        table.setTitle(title);
        table.setUrl(url);
        table.setTag(tag);
        table.setDescription(description);
        table.setRequestForm(requestForm);
        table.setResponseForm(responseForm);
        table.setRequestType(requestType);
        table.setRequestList(this.processRequestList(parameters, definitinMap));
        table.setResponseList(this.processResponseCodeList(responses));
        return table;
    }

    private Map<String, ModelAttr> parseDefinitions(Map<String, Object> map) {
        Map definitions = (Map)map.get("definitions");
        HashMap<String, ModelAttr> definitinMap = new HashMap<String, ModelAttr>(256);
        if (definitions != null) {
            for (String modeName : definitions.keySet()) {
                this.getAndPutModelAttr(definitions, definitinMap, modeName);
            }
        }
        return definitinMap;
    }

    private ModelAttr getAndPutModelAttr(Map<String, Map<String, Object>> swaggerMap, Map<String, ModelAttr> resMap, String modeName) {
        ModelAttr modeAttr = resMap.get("#/definitions/" + modeName);
        if (modeAttr == null) {
            modeAttr = new ModelAttr();
            resMap.put("#/definitions/" + modeName, modeAttr);
        } else if (modeAttr.isCompleted()) {
            return resMap.get("#/definitions/" + modeName);
        }
        Map modeProperties = (Map)swaggerMap.get(modeName).get("properties");
        if (modeProperties == null) {
            return null;
        }
        Iterator mIt = modeProperties.entrySet().iterator();
        ArrayList<ModelAttr> attrList = new ArrayList<ModelAttr>();
        while (mIt.hasNext()) {
            Map.Entry mEntry = mIt.next();
            Map attrInfoMap = (Map)mEntry.getValue();
            ModelAttr child = new ModelAttr();
            child.setName((String)mEntry.getKey());
            child.setType((String)attrInfoMap.get("type"));
            if (attrInfoMap.get("format") != null) {
                child.setType(child.getType() + "(" + attrInfoMap.get("format") + ")");
            }
            child.setType((String)StringUtils.defaultIfBlank((CharSequence)child.getType(), (CharSequence)"object"));
            Object ref = attrInfoMap.get("$ref");
            Object items = attrInfoMap.get("items");
            if (ref != null || items != null && (ref = ((Map)items).get("$ref")) != null) {
                String refName = ref.toString();
                String clsName = refName.substring(14);
                modeAttr.setCompleted(true);
                ModelAttr refModel = this.getAndPutModelAttr(swaggerMap, resMap, clsName);
                if (refModel != null) {
                    child.setProperties(refModel.getProperties());
                }
                child.setType(child.getType() + ":" + clsName);
            }
            child.setDescription((String)attrInfoMap.get("description"));
            attrList.add(child);
        }
        Object title = swaggerMap.get(modeName).get("title");
        Object description = swaggerMap.get(modeName).get("description");
        modeAttr.setClassName(title == null ? "" : title.toString());
        modeAttr.setDescription(description == null ? "" : description.toString());
        modeAttr.setProperties(attrList);
        return modeAttr;
    }

    private List<Request> processRequestList(List<LinkedHashMap> parameters, Map<String, ModelAttr> definitinMap) {
        ArrayList<Request> requestList = new ArrayList<Request>();
        if (!CollectionUtils.isEmpty(parameters)) {
            for (Map map : parameters) {
                Object in = map.get("in");
                Request request = new Request();
                request.setName(String.valueOf(map.get("name")));
                request.setType(map.get("type") == null ? "object" : map.get("type").toString());
                if (map.get("format") != null) {
                    request.setType(request.getType() + "(" + map.get("format") + ")");
                }
                request.setParamType(String.valueOf(in));
                if (in != null && "body".equals(in)) {
                    Map schema = (Map)map.get("schema");
                    Object ref = schema.get("$ref");
                    if (schema.get("type") != null && "array".equals(schema.get("type"))) {
                        ref = ((Map)schema.get("items")).get("$ref");
                        request.setType("array");
                    }
                    if (ref != null) {
                        request.setType(request.getType() + ":" + ref.toString().replaceAll("#/definitions/", ""));
                        request.setModelAttr(definitinMap.get(ref));
                    }
                }
                request.setRequire(false);
                if (map.get("required") != null) {
                    request.setRequire((Boolean)map.get("required"));
                }
                request.setRemark(String.valueOf(map.get("description")));
                requestList.add(request);
            }
        }
        return requestList;
    }

    private List<Response> processResponseCodeList(Map<String, Object> responses) {
        ArrayList<Response> responseList = new ArrayList<Response>();
        for (Map.Entry<String, Object> entry : responses.entrySet()) {
            Response response = new Response();
            response.setName(entry.getKey());
            LinkedHashMap statusCodeInfo = (LinkedHashMap)entry.getValue();
            response.setDescription(String.valueOf(statusCodeInfo.get("description")));
            Object schema = statusCodeInfo.get("schema");
            if (schema != null) {
                Object originalRef = ((LinkedHashMap)schema).get("originalRef");
                response.setRemark(originalRef == null ? "" : originalRef.toString());
            }
            responseList.add(response);
        }
        return responseList;
    }

    private ModelAttr processResponseModelAttrs(Map<String, Object> responseObj, Map<String, ModelAttr> definitinMap) {
        Map items;
        Map schema = (Map)responseObj.get("schema");
        String type = (String)schema.get("type");
        String ref = null;
        if ("array".equals(type) && (items = (Map)schema.get("items")) != null && items.get("$ref") != null) {
            ref = (String)items.get("$ref");
        }
        if (schema.get("$ref") != null) {
            ref = (String)schema.get("$ref");
        }
        ModelAttr modelAttr = new ModelAttr();
        modelAttr.setType((String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)""));
        if (StringUtils.isNotBlank((CharSequence)ref) && definitinMap.get(ref) != null) {
            modelAttr = definitinMap.get(ref);
        }
        return modelAttr;
    }

    private String processResponseParam(Map<String, Object> responseObj, Map<String, ModelAttr> definitinMap) throws JsonProcessingException {
        if (responseObj != null && responseObj.get("schema") != null) {
            ModelAttr modelAttr;
            Map items;
            Map schema = (Map)responseObj.get("schema");
            String type = (String)schema.get("type");
            String ref = null;
            if ("array".equals(type) && (items = (Map)schema.get("items")) != null && items.get("$ref") != null) {
                ref = (String)items.get("$ref");
            }
            if (schema.get("$ref") != null) {
                ref = (String)schema.get("$ref");
            }
            if (StringUtils.isNotEmpty(ref) && (modelAttr = definitinMap.get(ref)) != null && !CollectionUtils.isEmpty(modelAttr.getProperties())) {
                HashMap<String, Object> responseMap = new HashMap<String, Object>(8);
                for (ModelAttr subModelAttr : modelAttr.getProperties()) {
                    responseMap.put(subModelAttr.getName(), this.getValue(subModelAttr.getType(), subModelAttr));
                }
                return JsonUtils.writeJsonStr(responseMap);
            }
        }
        return "";
    }

    private String processRequestParam(List<Request> list) throws IOException {
        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        if (list != null && list.size() > 0) {
            for (Request request : list) {
                String name = request.getName();
                String paramType = request.getParamType();
                Object value = this.getValue(request.getType(), request.getModelAttr());
                switch (paramType) {
                    case "header": {
                        headerMap.put(name, value);
                        break;
                    }
                    case "query": {
                        queryMap.put(name, value);
                        break;
                    }
                    case "body": {
                        jsonMap.put(name, value);
                        break;
                    }
                }
            }
        }
        String res = "";
        if (!queryMap.isEmpty()) {
            res = res + WordServiceImpl.getUrlParamsByMap(queryMap);
        }
        if (!headerMap.isEmpty()) {
            res = res + " " + WordServiceImpl.getHeaderByMap(headerMap);
        }
        if (!jsonMap.isEmpty()) {
            if (jsonMap.size() == 1) {
                for (Map.Entry entry : jsonMap.entrySet()) {
                    res = res + " -d '" + JsonUtils.writeJsonStr(entry.getValue()) + "'";
                }
            } else {
                res = res + " -d '" + JsonUtils.writeJsonStr(jsonMap) + "'";
            }
        }
        return res;
    }

    private Object getValue(String type, ModelAttr modelAttr) {
        int pos = type.indexOf(":");
        if (pos != -1) {
            type = type.substring(0, pos);
        }
        switch (type) {
            case "string": {
                return "string";
            }
            case "string(date-time)": {
                return "2020/01/01 00:00:00";
            }
            case "integer": 
            case "integer(int64)": 
            case "integer(int32)": {
                return 0;
            }
            case "number": {
                return 0.0;
            }
            case "boolean": {
                return true;
            }
            case "file": {
                return "(binary)";
            }
            case "array": {
                ArrayList list = new ArrayList();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (modelAttr != null && !CollectionUtils.isEmpty(modelAttr.getProperties())) {
                    for (ModelAttr subModelAttr : modelAttr.getProperties()) {
                        map.put(subModelAttr.getName(), this.getValue(subModelAttr.getType(), subModelAttr));
                    }
                }
                list.add(map);
                return list;
            }
            case "object": {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (modelAttr != null && !CollectionUtils.isEmpty(modelAttr.getProperties())) {
                    for (ModelAttr subModelAttr : modelAttr.getProperties()) {
                        map.put(subModelAttr.getName(), this.getValue(subModelAttr.getType(), subModelAttr));
                    }
                }
                return map;
            }
        }
        return null;
    }

    public static String getUrlParamsByMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = StringUtils.substringBeforeLast((String)s, (String)"&");
        }
        return s;
    }

    public static String getHeaderByMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("--header '");
            sb.append(entry.getKey() + ":" + entry.getValue());
            sb.append("'");
        }
        return sb.toString();
    }
}

