package com.sinosoftgz.starter.swagger.properties;


import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

/**
 * @author: Roney
 * @date: 2021-10-15 10:25
 * @description: Swagger2Properties
 */
@ConfigurationProperties(prefix = Swagger2Properties.SWAGGER_PREFIX)
@Data
public class Swagger2Properties {

    public static final String SWAGGER_PREFIX = "swagger";

    /**
     * 默认扫描的基础包
     */
    private static final String DEFAULT_BASE_PACKAGE = "com.sinosoftgz.starter.swagger.controller";

    /**
     * 定义分隔符,配置Swagger多包
     */

    private static final String SPLITOR = ",";

    /**
     * 是否开启redis锁
     * 默认不开启
     */
    private boolean enabled = false;


    /**
     * API接口包路径
     */
    private String basePackage;

    /**
     * API页面标题
     */
    private String title;

    /**
     * API描述
     */
    private String description;

    /**
     * 服务条款地址
     */
    private String termsOfServiceUrl;

    /**
     * 版本号
     */
    private String version;

    /**
     * 联系人
     */
    private springfox.documentation.service.Contact contact;

    public void setBasePackage(String basePackage) {
        if (!StringUtils.isEmpty(basePackage)) {
            StringBuffer sb = new StringBuffer(basePackage);
            sb.append(SPLITOR).append(DEFAULT_BASE_PACKAGE);
            this.basePackage = sb.toString();
        }
    }
}
