/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.swagger.controller;

import com.sinosoftgz.starter.swagger.service.WordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Controller
@Api(tags={"To Word API"})
@RequestMapping(value={"/swagger"})
@ConditionalOnProperty(prefix="swagger", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class Swagger2DocController {
    private static final Logger log = LoggerFactory.getLogger(Swagger2DocController.class);
    @Resource
    private WordService tableService;
    @Autowired
    private SpringTemplateEngine springTemplateEngine;
    private String DEFAULT_FILE_NAME = "swagger2word";

    @ApiOperation(value="\u5c06swagger\u6587\u6863\u4e0b\u8f7d\u4e3adoc\u6587\u6863")
    @ApiResponses(value={@ApiResponse(code=200, message="\u8bf7\u6c42\u6210\u529f\u3002")})
    @RequestMapping(value={"/downloadWord"}, method={RequestMethod.GET})
    public void downloadWord(Model model, @ApiParam(value="\u8d44\u6e90\u5730\u5740", required=true) @RequestParam(required=true) String url, HttpServletResponse response, @ApiParam(value="\u4fdd\u5b58\u6587\u4ef6\u540d\u79f0", required=false) @RequestParam(required=false) String fileName) {
        this.generateModelData(model, url, 1);
        this.writeContentToResponse(model, fileName, response);
    }

    private void generateModelData(Model model, String url, Integer download) {
        Map<String, Object> result = this.tableService.tableList(url);
        model.addAttribute("url", (Object)url);
        model.addAttribute("download", (Object)download);
        model.addAllAttributes(result);
    }

    private void writeContentToResponse(Model model, String fileName, HttpServletResponse response) {
        if (StringUtils.isEmpty((Object)fileName)) {
            fileName = this.DEFAULT_FILE_NAME;
        }
        Context context = new Context();
        context.setVariables(model.asMap());
        String content = this.springTemplateEngine.process("word", (IContext)context);
        response.setContentType("application/octet-stream;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".doc", "utf-8"));
            byte[] bytes = content.getBytes();
            bos.write(bytes, 0, bytes.length);
            bos.flush();
        }
        catch (IOException e) {
            log.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
    }
}

