package com.sinosoftgz.starter.template.freemarker.config;

import com.sinosoftgz.starter.template.freemarker.EncodeUrlMethod;
import com.sinosoftgz.starter.template.freemarker.constant.FreeMarkerConstant;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import javax.servlet.ServletContext;


/**
 * Created by Roney on 2019/8/17.
 *
 * @author Roney
 * @date 2019-08-17 19:21
 */
@Configuration
@ConfigurationProperties(prefix = "context")
@Data
public class FreeMarkerConfiguration implements InitializingBean, ServletContextAware {
    @Autowired
    FreeMarkerConfigurer freeMarkerConfigurer;

    /**
     * 公共静态文件路径
     */

    private String commonstatic;
    /**
     * 项目静态文件路径
     */

    private String projectstatic;
    /**
     * 项目静态内容路径
     */

    private String ctx;

    @Autowired
    ResourceUrlProvider resourceUrlProvider;

    @Bean
    public EncodeUrlMethod encodeUrlMethod() {
        return new EncodeUrlMethod(resourceUrlProvider);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //设置各个内容的访问前缀，没有配置为contextpath
        freemarker.template.Configuration configuration = freeMarkerConfigurer.getConfiguration();
        String projectContextPath = servletContext.getContextPath();
        configuration.setSharedVariable(FreeMarkerConstant.CONTENT.C_STATIC, commonstatic);
        if (StringUtils.isEmpty(commonstatic)) {
            configuration.setSharedVariable(FreeMarkerConstant.CONTENT.C_STATIC, projectContextPath);
        }
        configuration.setSharedVariable(FreeMarkerConstant.CONTENT.P_STATIC, projectstatic);
        if (StringUtils.isEmpty(projectstatic)) {
            configuration.setSharedVariable(FreeMarkerConstant.CONTENT.P_STATIC, projectContextPath);
        }
        configuration.setSharedVariable(FreeMarkerConstant.CONTENT.CTX, ctx);
        if (StringUtils.isEmpty(ctx)) {
            configuration.setSharedVariable(FreeMarkerConstant.CONTENT.CTX, projectContextPath);
        }
        freeMarkerConfigurer.getConfiguration().setSharedVariable(FreeMarkerConstant.CONTENT.VERSION, encodeUrlMethod());
    }

    ServletContext servletContext;

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}
