/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.template.freemarker.config;

import com.sinosoftgz.starter.template.freemarker.EncodeUrlMethod;
import freemarker.template.TemplateModel;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@ConfigurationProperties(prefix="context")
public class FreeMarkerConfiguration
implements InitializingBean,
ServletContextAware {
    @Autowired
    FreeMarkerConfigurer freeMarkerConfigurer;
    private String commonstatic;
    private String projectstatic;
    private String ctx;
    @Autowired
    ResourceUrlProvider resourceUrlProvider;
    ServletContext servletContext;

    @Bean
    public EncodeUrlMethod encodeUrlMethod() {
        return new EncodeUrlMethod(this.resourceUrlProvider);
    }

    public void afterPropertiesSet() throws Exception {
        freemarker.template.Configuration configuration = this.freeMarkerConfigurer.getConfiguration();
        String projectContextPath = this.servletContext.getContextPath();
        configuration.setSharedVariable("c_static", (Object)this.commonstatic);
        if (StringUtils.isEmpty((Object)this.commonstatic)) {
            configuration.setSharedVariable("c_static", (Object)projectContextPath);
        }
        configuration.setSharedVariable("p_static", (Object)this.projectstatic);
        if (StringUtils.isEmpty((Object)this.projectstatic)) {
            configuration.setSharedVariable("p_static", (Object)projectContextPath);
        }
        configuration.setSharedVariable("ctx", (Object)this.ctx);
        if (StringUtils.isEmpty((Object)this.ctx)) {
            configuration.setSharedVariable("ctx", (Object)projectContextPath);
        }
        this.freeMarkerConfigurer.getConfiguration().setSharedVariable("_v", (TemplateModel)this.encodeUrlMethod());
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public FreeMarkerConfigurer getFreeMarkerConfigurer() {
        return this.freeMarkerConfigurer;
    }

    public String getCommonstatic() {
        return this.commonstatic;
    }

    public String getProjectstatic() {
        return this.projectstatic;
    }

    public String getCtx() {
        return this.ctx;
    }

    public ResourceUrlProvider getResourceUrlProvider() {
        return this.resourceUrlProvider;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setFreeMarkerConfigurer(FreeMarkerConfigurer freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    public void setCommonstatic(String commonstatic) {
        this.commonstatic = commonstatic;
    }

    public void setProjectstatic(String projectstatic) {
        this.projectstatic = projectstatic;
    }

    public void setCtx(String ctx) {
        this.ctx = ctx;
    }

    public void setResourceUrlProvider(ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreeMarkerConfiguration)) {
            return false;
        }
        FreeMarkerConfiguration other = (FreeMarkerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FreeMarkerConfigurer this$freeMarkerConfigurer = this.getFreeMarkerConfigurer();
        FreeMarkerConfigurer other$freeMarkerConfigurer = other.getFreeMarkerConfigurer();
        if (this$freeMarkerConfigurer == null ? other$freeMarkerConfigurer != null : !this$freeMarkerConfigurer.equals(other$freeMarkerConfigurer)) {
            return false;
        }
        String this$commonstatic = this.getCommonstatic();
        String other$commonstatic = other.getCommonstatic();
        if (this$commonstatic == null ? other$commonstatic != null : !this$commonstatic.equals(other$commonstatic)) {
            return false;
        }
        String this$projectstatic = this.getProjectstatic();
        String other$projectstatic = other.getProjectstatic();
        if (this$projectstatic == null ? other$projectstatic != null : !this$projectstatic.equals(other$projectstatic)) {
            return false;
        }
        String this$ctx = this.getCtx();
        String other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        ResourceUrlProvider this$resourceUrlProvider = this.getResourceUrlProvider();
        ResourceUrlProvider other$resourceUrlProvider = other.getResourceUrlProvider();
        if (this$resourceUrlProvider == null ? other$resourceUrlProvider != null : !this$resourceUrlProvider.equals(other$resourceUrlProvider)) {
            return false;
        }
        ServletContext this$servletContext = this.getServletContext();
        ServletContext other$servletContext = other.getServletContext();
        return !(this$servletContext == null ? other$servletContext != null : !this$servletContext.equals(other$servletContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FreeMarkerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FreeMarkerConfigurer $freeMarkerConfigurer = this.getFreeMarkerConfigurer();
        result = result * 59 + ($freeMarkerConfigurer == null ? 43 : $freeMarkerConfigurer.hashCode());
        String $commonstatic = this.getCommonstatic();
        result = result * 59 + ($commonstatic == null ? 43 : $commonstatic.hashCode());
        String $projectstatic = this.getProjectstatic();
        result = result * 59 + ($projectstatic == null ? 43 : $projectstatic.hashCode());
        String $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        ResourceUrlProvider $resourceUrlProvider = this.getResourceUrlProvider();
        result = result * 59 + ($resourceUrlProvider == null ? 43 : $resourceUrlProvider.hashCode());
        ServletContext $servletContext = this.getServletContext();
        result = result * 59 + ($servletContext == null ? 43 : $servletContext.hashCode());
        return result;
    }

    public String toString() {
        return "FreeMarkerConfiguration(freeMarkerConfigurer=" + this.getFreeMarkerConfigurer() + ", commonstatic=" + this.getCommonstatic() + ", projectstatic=" + this.getProjectstatic() + ", ctx=" + this.getCtx() + ", resourceUrlProvider=" + this.getResourceUrlProvider() + ", servletContext=" + this.getServletContext() + ")";
    }
}

