/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtils {
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolUtils.class);
    private static List<ExecutorService> executorServices = new ArrayList<ExecutorService>();

    public static ExecutorService createThreadPool(String threadNamePrefix) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 10, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(threadNamePrefix));
        executorServices.add(executorService);
        return executorService;
    }

    public static ExecutorService createThreadPool(Integer coreSize, String threadNamePrefix) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor((int)coreSize, (int)coreSize, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(threadNamePrefix));
        executorServices.add(executorService);
        return executorService;
    }

    public static ExecutorService createThreadPool(String threadNamePrefix, Integer taskQueueSize) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 20, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(taskQueueSize), new DefaultThreadFactory(threadNamePrefix));
        executorServices.add(executorService);
        return executorService;
    }

    public static ExecutorService createThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String threadNamePrefix) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new DefaultThreadFactory(threadNamePrefix));
        executorServices.add(executorService);
        return executorService;
    }

    public static ExecutorService createThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        executorServices.add(executorService);
        return executorService;
    }

    public static ExecutorService createThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        executorServices.add(executorService);
        return executorService;
    }

    public static ExecutorService createThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        executorServices.add(executorService);
        return executorService;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(corePoolSize);
        executorServices.add(scheduledThreadPoolExecutor);
        return scheduledThreadPoolExecutor;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        executorServices.add(scheduledThreadPoolExecutor);
        return scheduledThreadPoolExecutor;
    }

    public static void shutdown() {
        for (ExecutorService executorService : executorServices) {
            try {
                if (executorService.isShutdown()) continue;
                executorService.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("Success to close all user thread pool");
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String threadNamePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + POOL_NUMBER.getAndIncrement() + "-" + threadNamePrefix + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

