/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.data;

import com.sinosoftgz.global.common.response.page.ResultPage;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;

public class CopyUtils {
    private static List<String> copyPackageList = Arrays.asList(String.class.getPackage().getName(), BigDecimal.class.getPackage().getName(), Date.class.getPackage().getName());
    private static String idCopyProperty = "id";
    private static String idCopyPropertyMethod = "getId";

    public static <S, D> D map(S source, Class<D> destinationClass) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = source.getClass();
        AccessibleObject[] destinationDeclaredFields = destinationClass.getDeclaredFields();
        D destinationObject = null;
        try {
            destinationObject = destinationClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class<D> destinationHolderClass = destinationClass;
        Class<?> sourceHolderClass = sourceClass;
        while (destinationDeclaredFields != null && destinationDeclaredFields.length > 0) {
            Field.setAccessible(destinationDeclaredFields, true);
            for (AccessibleObject destinationDeclaredField : destinationDeclaredFields) {
                try {
                    if (Collection.class.isAssignableFrom(((Field)destinationDeclaredField).getType())) {
                        ((Field)destinationDeclaredField).set(destinationObject, null);
                        continue;
                    }
                    Field sourcedDclaredField = null;
                    Class<?> holderSourceClass = sourceHolderClass;
                    do {
                        try {
                            sourcedDclaredField = holderSourceClass.getDeclaredField(((Field)destinationDeclaredField).getName());
                        }
                        catch (Exception e) {
                            if (holderSourceClass.getSuperclass() == null) break;
                            holderSourceClass = holderSourceClass.getSuperclass();
                        }
                    } while (sourcedDclaredField == null);
                    sourcedDclaredField.setAccessible(true);
                    Object sourceFieldValue = sourcedDclaredField.get(source);
                    if (sourceFieldValue == null) {
                        String dclaredFieldName = sourcedDclaredField.getName();
                        String methodName = "get" + dclaredFieldName.substring(0, 1).toUpperCase() + dclaredFieldName.substring(1);
                        Method holderSourceClassDeclaredMethod = holderSourceClass.getDeclaredMethod(methodName, new Class[0]);
                        sourceFieldValue = holderSourceClassDeclaredMethod.invoke(source, new Object[0]);
                    }
                    if (sourceFieldValue == null) continue;
                    if (((Field)destinationDeclaredField).getType().isPrimitive() || copyPackageList.contains(((Field)destinationDeclaredField).getType().getPackage().getName())) {
                        ((Field)destinationDeclaredField).set(destinationObject, sourceFieldValue);
                        continue;
                    }
                    Class<?> idClass = ((Field)destinationDeclaredField).getType();
                    Object sourceIdFieldValue = null;
                    Field desidField = idClass.getDeclaredField(idCopyProperty);
                    try {
                        Field idField = sourceFieldValue.getClass().getDeclaredField(idCopyProperty);
                        idField.setAccessible(true);
                        sourceIdFieldValue = idField.get(sourceFieldValue);
                    }
                    catch (Exception idField) {
                        // empty catch block
                    }
                    if (sourceIdFieldValue == null) {
                        Method idClassDeclaredMethod = sourceFieldValue.getClass().getDeclaredMethod(idCopyPropertyMethod, new Class[0]);
                        sourceIdFieldValue = idClassDeclaredMethod.invoke(sourceFieldValue, new Object[0]);
                    }
                    if (sourceIdFieldValue == null) continue;
                    Object idObject = idClass.newInstance();
                    desidField.setAccessible(true);
                    desidField.set(idObject, sourceIdFieldValue);
                    ((Field)destinationDeclaredField).set(destinationObject, idObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            destinationHolderClass = destinationHolderClass.getSuperclass();
            destinationDeclaredFields = destinationHolderClass.getDeclaredFields();
        }
        return destinationObject;
    }

    public static <S, D> List<D> mapList(Collection<S> sourceList, Class<D> destinationHolderClass) {
        CopyOnWriteArrayList destinationList = new CopyOnWriteArrayList();
        if (sourceList != null && !sourceList.isEmpty()) {
            sourceList.forEach(source -> destinationList.add(CopyUtils.map(source, destinationHolderClass)));
        }
        return destinationList;
    }

    public static <S, D> List<D> parallelMapList(Collection<S> sourceList, Class<D> destinationHolderClass) {
        CopyOnWriteArrayList destinationList = new CopyOnWriteArrayList();
        if (sourceList != null && !sourceList.isEmpty()) {
            ((Stream)sourceList.stream().parallel()).forEach(source -> destinationList.add(CopyUtils.map(source, destinationHolderClass)));
        }
        return destinationList;
    }

    public static <S, D> ResultPage<D> mapPage(Page<S> page, Class<D> destinationHolderClass) {
        ResultPage resultPage = new ResultPage();
        resultPage.setData(CopyUtils.mapList(page.getContent(), destinationHolderClass));
        resultPage.setPageNo((long)page.getNumber());
        resultPage.setTotalCount((long)page.getTotalPages());
        return resultPage;
    }
}

