/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.lang;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings {
    private static final Logger log = LoggerFactory.getLogger(Strings.class);
    private static final char SEPARATOR = '_';
    private static final int NATIVE2ASCII_LENGTH = 6;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final int SEVEN = 7;
    private static final int EIGHT = 8;
    private static final int NINE = 9;

    private Strings() {
    }

    public static String newString(String value, int length) {
        if (value == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static String newString(char ch, int length) {
        return Strings.newString(String.valueOf(ch), length);
    }

    public static String copyString(String str, int copyTimes) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < copyTimes; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static int getBytesLength(String str, String charsetName) {
        if (str == null) {
            return -1;
        }
        try {
            return str.getBytes(charsetName).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int indexOf(String str, String subStr, int startIndex, int occurrenceTimes) {
        if (occurrenceTimes <= 0) {
            return -1;
        }
        if (str.length() - 1 < startIndex) {
            return -1;
        }
        if ("".equals(subStr)) {
            return 0;
        }
        int foundCount = 0;
        int index = startIndex;
        int substrLength = subStr.length();
        while (foundCount < occurrenceTimes) {
            if ((index = str.indexOf(subStr, index)) == -1) {
                return -1;
            }
            ++foundCount;
            index += substrLength;
        }
        return index - substrLength;
    }

    public static int indexOf(String str, String subStr, int occurrenceTimes) {
        return Strings.indexOf(str, subStr, 0, occurrenceTimes);
    }

    public static int indexOf(String str, String subStr, int fromIndex, boolean caseSensitive) {
        if (!caseSensitive) {
            return str.toLowerCase(Locale.getDefault()).indexOf(subStr.toLowerCase(Locale.getDefault()), fromIndex);
        }
        return str.indexOf(subStr, fromIndex);
    }

    public static String replace(String str, String searchStr, String replaceStr, boolean caseSensitive) {
        if (str == null) {
            return null;
        }
        if ("".equals(str)) {
            return "";
        }
        if (searchStr == null || "".equals(searchStr)) {
            return str;
        }
        String newReplaceStr = replaceStr;
        if (replaceStr == null) {
            newReplaceStr = "";
        }
        int i = 0;
        int j = 0;
        StringBuilder buffer = new StringBuilder();
        while ((j = Strings.indexOf(str, searchStr, i, caseSensitive)) > -1) {
            buffer.append(str.substring(i, j));
            buffer.append(newReplaceStr);
            i = j + searchStr.length();
        }
        buffer.append(str.substring(i));
        return buffer.toString();
    }

    public static String replace(String str, String searchStr, String replaceStr) {
        return Strings.replace(str, searchStr, replaceStr, true);
    }

    public static String replace(String str, char searchChar, String replaceStr) {
        return Strings.replace(str, String.valueOf(searchChar), replaceStr, true);
    }

    public static String replace(String str, int beginIndex, String replaceStr) {
        if (str == null) {
            return null;
        }
        String newReplaceStr = replaceStr;
        if (replaceStr == null) {
            newReplaceStr = "";
        }
        StringBuilder buffer = new StringBuilder(str.substring(0, beginIndex));
        buffer.append(newReplaceStr);
        buffer.append(str.substring(beginIndex + newReplaceStr.length()));
        return buffer.toString();
    }

    public static String[] split(String originalString, int splitByteLength, String charsetName) {
        if (originalString == null) {
            return new String[0];
        }
        if ("".equals(originalString)) {
            return new String[0];
        }
        if ("".equals(originalString.trim())) {
            return new String[]{""};
        }
        if (splitByteLength <= 1) {
            return new String[]{originalString};
        }
        String strText = null;
        int intStartIndex = 0;
        int intEndIndex = 0;
        int index = 0;
        int fixCount = 0;
        String[] arrReturn = null;
        ArrayList<String> strList = new ArrayList<String>();
        int loopCount = 0;
        try {
            byte[] arrByte = originalString.getBytes(charsetName);
            intEndIndex = 0;
            while (true) {
                if (++loopCount > 1024) {
                    log.error("Can't split(\"{}\",{}). default charset is {}", new Object[]{originalString, splitByteLength, System.getProperty("file.encoding")});
                    throw new IllegalStateException("Can't split,loop count is " + loopCount);
                }
                intStartIndex = intEndIndex;
                intEndIndex = intStartIndex + splitByteLength;
                if (intStartIndex >= arrByte.length) break;
                if (intEndIndex > arrByte.length) {
                    intEndIndex = arrByte.length;
                    strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex, charsetName);
                    strList.add(strText);
                    break;
                }
                fixCount = 0;
                strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex, charsetName);
                byte[] bytes = strText.getBytes(charsetName);
                if (bytes.length < splitByteLength) {
                    intEndIndex = intStartIndex + bytes.length;
                }
                for (index = intEndIndex - 1; index >= intStartIndex && arrByte[index] != bytes[index - intStartIndex]; --index) {
                    ++fixCount;
                }
                if (fixCount > 0) {
                    if (fixCount >= intEndIndex) {
                        fixCount = 0;
                        log.debug("split length {} is too small.", (Object)splitByteLength);
                    }
                    strText = new String(arrByte, intStartIndex, (intEndIndex -= fixCount) - intStartIndex, charsetName);
                }
                if (intStartIndex == intEndIndex) {
                    log.error("Can't split(\"{}\",{}). default charset is {}", new Object[]{originalString, splitByteLength, System.getProperty("file.encoding")});
                    throw new IllegalStateException("Can't split(\"" + originalString + "\"," + splitByteLength + "). default charset is " + System.getProperty("file.encoding"));
                }
                strList.add(strText);
            }
            arrReturn = new String[strList.size()];
            strList.toArray(arrReturn);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return arrReturn;
    }

    public static String[] split(String originalString, String delimiterString) {
        if (originalString == null || delimiterString == null || "".equals(originalString)) {
            return new String[0];
        }
        if ("".equals(delimiterString) || originalString.length() < delimiterString.length()) {
            return new String[]{originalString};
        }
        int index = 0;
        String[] returnArray = null;
        int length = 0;
        String strTemp = originalString;
        while (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{strTemp}) && (index = strTemp.indexOf(delimiterString)) != -1) {
            ++length;
            strTemp = strTemp.substring(index + delimiterString.length());
        }
        returnArray = new String[++length];
        strTemp = originalString;
        for (int i = 0; i < length - 1; ++i) {
            index = strTemp.indexOf(delimiterString);
            returnArray[i] = strTemp.substring(0, index);
            strTemp = strTemp.substring(index + delimiterString.length());
        }
        returnArray[length - 1] = strTemp;
        return returnArray;
    }

    public static String rightTrim(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        for (int i = length - 1; i >= 0 && str.charAt(i) == ' '; --i) {
            --length;
        }
        return str.substring(0, length);
    }

    public static String leftTrim(String str) {
        if (str == null) {
            return "";
        }
        int start = 0;
        int n = str.length();
        for (int i = 0; i < n && str.charAt(i) == ' '; ++i) {
            ++start;
        }
        return str.substring(start);
    }

    public static String absoluteTrim(String str) {
        return Strings.replace(str, " ", "");
    }

    public static String lowerCase(String str, int beginIndex, int endIndex) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toLowerCase(Locale.getDefault()));
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String upperCase(String str, int beginIndex, int endIndex) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toUpperCase(Locale.getDefault()));
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String lowerCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toLowerCase(Locale.getDefault()) + iString.substring(1);
        return newString;
    }

    public static String upperCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toUpperCase(Locale.getDefault()) + iString.substring(1);
        return newString;
    }

    public static int timesOf(String str, String subStr) {
        if ("".equals(subStr)) {
            return 0;
        }
        int fromIndex = str.indexOf(subStr);
        int foundCount = 0;
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(subStr, fromIndex + subStr.length());
        }
        return foundCount;
    }

    public static int timesOf(String str, char ch) {
        int foundCount = 0;
        int fromIndex = str.indexOf(ch);
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(ch, fromIndex + 1);
        }
        return foundCount;
    }

    public static Map<String, String> toMap(String str, String splitString) {
        if (splitString == null) {
            splitString = "";
        }
        Map<String, String> map = Collections.synchronizedMap(new HashMap());
        String[] values = Strings.split(str, splitString);
        for (int i = 0; i < values.length; ++i) {
            String tempValue = values[i];
            int pos = tempValue.indexOf(61);
            String key = "";
            String value = "";
            if (pos > -1) {
                key = tempValue.substring(0, pos);
                value = tempValue.substring(pos + splitString.length());
            } else {
                key = tempValue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static String native2ascii(String str) {
        char[] ca = str.toCharArray();
        StringBuilder buffer = new StringBuilder(ca.length * 6);
        for (int x = 0; x < ca.length; ++x) {
            char a = ca[x];
            if (a > '\u00ff') {
                buffer.append("\\u").append(Integer.toHexString(a));
                continue;
            }
            buffer.append(a);
        }
        return buffer.toString();
    }

    public static Map<String, String> sortEnglishNumberWord(Map<String, String> map) {
        int i;
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(0);
        LinkedHashMap<Integer, String> tempMap = new LinkedHashMap<Integer, String>(0);
        Set<String> keys = map.keySet();
        int s = Integer.MAX_VALUE;
        for (String key : keys) {
            if (key.indexOf("One") > -1) {
                tempMap.put(1, key);
            } else if (key.indexOf("Two") > -1) {
                tempMap.put(2, key);
            } else if (key.indexOf("Three") > -1) {
                tempMap.put(3, key);
            } else if (key.indexOf("Four") > -1) {
                tempMap.put(4, key);
            } else if (key.indexOf("Five") > -1) {
                tempMap.put(5, key);
            } else if (key.indexOf("Six") > -1) {
                tempMap.put(6, key);
            } else if (key.indexOf("Seven") > -1) {
                tempMap.put(7, key);
            } else if (key.indexOf("Eight") > -1) {
                tempMap.put(8, key);
            } else if (key.indexOf("Nine") > -1) {
                tempMap.put(9, key);
            } else {
                tempMap.put(s, key);
            }
            --s;
        }
        Set keyNum = tempMap.keySet();
        Object[] numObj = keyNum.toArray();
        Integer[] nums = new Integer[numObj.length];
        Integer tempInt = 0;
        for (i = 0; i < numObj.length; ++i) {
            nums[i] = Integer.valueOf(numObj[i].toString());
        }
        for (i = 0; i < nums.length; ++i) {
            for (int j = 0; j < nums.length - i - 1; ++j) {
                if (nums[j] <= nums[j + 1]) continue;
                tempInt = nums[j];
                nums[j] = nums[j + 1];
                nums[j + 1] = tempInt;
            }
        }
        for (Integer num : nums) {
            resultMap.put((String)tempMap.get(num), map.get(tempMap.get(num)));
        }
        return resultMap;
    }

    public static String concat(Object ... sources) {
        if (sources == null) {
            return "";
        }
        if (sources.length == 1) {
            return String.valueOf(sources[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : sources) {
            sb.append(o);
        }
        return sb.toString();
    }

    public static Iterator<String> splitIgnoreBlank(final String str, final String delimiters) {
        if (null == str) {
            return null;
        }
        return new Iterator<String>(){
            private int fromIndex;
            private String subString;

            @Override
            public boolean hasNext() {
                if (this.subString == null || this.subString.length() == 0) {
                    if (this.fromIndex + delimiters.length() > str.length()) {
                        return false;
                    }
                    int index = str.indexOf(delimiters, this.fromIndex);
                    if (index == -1) {
                        index = str.length();
                    }
                    this.subString = str.substring(this.fromIndex, index).trim();
                    this.fromIndex = index + delimiters.length();
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.subString == null) {
                    throw new IllegalStateException("Should be call hasNext first");
                }
                String s = this.subString;
                this.subString = null;
                return s;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean isEmptyOrNull(String value) {
        boolean result = false;
        if (value == null || "null".equals(value) || value.trim().length() == 0) {
            result = true;
        }
        return result;
    }

    public static String toUnderlineName(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(in.length());
        boolean upperCase = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean nextUpperCase = true;
            if (i < in.length() - 1) {
                nextUpperCase = Character.isUpperCase(in.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCamelCase(String in) {
        if (in == null) {
            return null;
        }
        String str = in.toLowerCase(Locale.getDefault());
        StringBuilder sb = new StringBuilder(str.length());
        boolean upperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String in) {
        if (in == null) {
            return null;
        }
        String str = Strings.toCamelCase(in);
        return str.substring(0, 1).toUpperCase(Locale.getDefault()) + str.substring(1);
    }
}

