/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.lang;

import org.apache.commons.codec.binary.Base64;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;

public final class Uuids {
    private static UUIDGenerator generator = UUIDGenerator.getInstance();
    private static final int SHORT_UUID_LEN = 22;
    private static final int LONG_UUID_LEN = 32;
    private static final int UUID_SPLIT_POS_1 = 8;
    private static final int UUID_SPLIT_POS_2 = 13;
    private static final int UUID_SPLIT_POS_3 = 18;
    private static final int UUID_SPLIT_POS_4 = 23;

    private Uuids() {
    }

    public static String longUuid() {
        UUID uuid = generator.generateRandomBasedUUID();
        return uuid.toString().replace("-", "");
    }

    public static String shortUuid() {
        UUID uuid = generator.generateRandomBasedUUID();
        return Uuids.compressedUUID(uuid);
    }

    private static String compressedUUID(UUID uuid) {
        return Base64.encodeBase64URLSafeString((byte[])uuid.asByteArray());
    }

    public static String longUuid2short(String longUuid) {
        if (longUuid.length() != 32) {
            throw new IllegalArgumentException("Invalid uuid!" + longUuid);
        }
        StringBuilder sb = new StringBuilder(longUuid);
        sb.insert(8, '-');
        sb.insert(13, '-');
        sb.insert(18, '-');
        sb.insert(23, '-');
        UUID uuid = UUID.valueOf((String)sb.toString());
        return Uuids.compressedUUID(uuid);
    }

    public static String shortUuid2long(String shortUuid) {
        if (shortUuid.length() != 22) {
            throw new IllegalArgumentException("Invalid uuid!" + shortUuid);
        }
        byte[] byUuid = Base64.decodeBase64((String)(shortUuid + "=="));
        UUID uuid = new UUID(byUuid);
        return uuid.toString().replace("-", "");
    }
}

