package com.sinosoftgz.starter.utils.convert.converters.array;

import com.sinosoftgz.starter.utils.convert.Converter;
import com.sinosoftgz.starter.utils.lang.Lang;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;

/**
 * @author Roney
 */
@SuppressWarnings("ALL")
public class BlobToByteArrayConverter implements Converter {

    @Override
    public Object convert(Object from, Class<?> toType, Object... args) {
        Blob blob = (Blob) from;
        try {
            return IOUtils.toByteArray(blob.getBinaryStream());
        } catch (IOException e) {
            throw Lang.unchecked(e);
        } catch (SQLException e) {
            throw Lang.unchecked(e);
        }
    }

}
