package com.sinosoftgz.starter.utils.convert.converters.array;


import com.sinosoftgz.starter.utils.convert.Converter;
import com.sinosoftgz.starter.utils.convert.Converters;
import com.sinosoftgz.starter.utils.lang.Lang;

import java.lang.reflect.Array;
import java.util.Collection;

/**
 * @author Roney
 */
@SuppressWarnings("ALL")
public class CollectionToArrayConverter implements Converter {

    @Override
    public Object convert(Object from, Class<?> toType, Object... args) {
        Collection<?> collection = (Collection<?>) from;
        try {
            Object array = Array.newInstance(toType.getComponentType(),
                    collection.size());
            int i = 0;
            for (Object object : collection) {
                Array.set(
                        array,
                        i,
                        Converters.BASE.convert(object,
                                toType.getComponentType()));
                i++;
            }
            return array;
        } catch (Exception e) {
            throw Lang.unchecked(e);
        }
    }

}
