package com.sinosoftgz.starter.utils.convert.converters.primitive;


import com.sinosoftgz.starter.utils.convert.Converter;
import com.sinosoftgz.starter.utils.convert.Converters;
import com.sinosoftgz.starter.utils.lang.Lang;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

/**
 * @author Roney
 */
@SuppressWarnings("ALL")
public class ObjectToFloatConverter implements Converter {

    @Override
    public Object convert(Object from, Class<?> toType, Object... args) {
        String string = Converters.BASE.convert(from, String.class);
        if (args != null && args.length != 0 && args[0] != null) {
            NumberFormat format;
            if (args[0] instanceof NumberFormat) {
                format = (NumberFormat) args[0];
            } else {
                format = new DecimalFormat(args[0].toString());
            }
            try {
                return ((Number) format.parseObject(string)).floatValue();
            } catch (ParseException e) {
                throw Lang.unchecked(e);
            }
        }
        return Float.valueOf(string);
    }

}
