package com.sinosoftgz.starter.utils.convert.converters.string;

import com.sinosoftgz.starter.utils.convert.Converter;
import com.sinosoftgz.starter.utils.lang.Lang;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;

/**
 * @author Roney
 */
@SuppressWarnings("ALL")
public class ClobToStringConverter implements Converter {

    @Override
    public Object convert(Object from, Class<?> toType, Object... args) {
        Clob clob = (Clob) from;
        try {
            return IOUtils.toString(clob.getCharacterStream());
        } catch (IOException e) {
            throw Lang.unchecked(e);
        } catch (SQLException e) {
            throw Lang.unchecked(e);
        }
    }

}
