package com.sinosoftgz.starter.utils.lang;


import lombok.extern.slf4j.Slf4j;

import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Object ID 24位通用ID生成器
 *
 * @author Roney
 */
@SuppressWarnings("ALL")
@Slf4j
public class OID {


    private static AtomicInteger nextInc = new AtomicInteger(
            (new Random()).nextInt());

    private static final int GENMACHINE;

    static {
        try {
            int machinePiece;
            {
                try {
                    StringBuilder sb = new StringBuilder();
                    Enumeration<NetworkInterface> e = NetworkInterface
                            .getNetworkInterfaces();
                    while (e.hasMoreElements()) {
                        NetworkInterface ni = e.nextElement();
                        sb.append(ni.toString());
                    }
                    machinePiece = sb.toString().hashCode() << 16;
                } catch (Throwable e) {
                    machinePiece = (new Random().nextInt()) << 16;
                }
                log.debug("machine piece post: {}",
                        Integer.toHexString(machinePiece));
            }

            final int processPiece;
            {
                int processId = new Random().nextInt();
                try {
                    processId = java.lang.management.ManagementFactory
                            .getRuntimeMXBean().getName().hashCode();
                } catch (Throwable t) {
                }

                ClassLoader loader = OID.class.getClassLoader();
                int loaderId = loader != null ? System.identityHashCode(loader)
                        : 0;

                StringBuilder sb = new StringBuilder();
                sb.append(Integer.toHexString(processId));
                sb.append(Integer.toHexString(loaderId));
                processPiece = sb.toString().hashCode() & 0xFFFF;
                log.debug("process piece: {}",
                        Integer.toHexString(processPiece));
            }

            GENMACHINE = machinePiece | processPiece;
            log.debug("machine : {}", Integer.toHexString(GENMACHINE));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int time;

    private int machine;

    private int inc;

    public OID() {
        time = (int) (System.currentTimeMillis() / 1000);
        machine = GENMACHINE;
        inc = nextInc.getAndIncrement();
    }

    public byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(time);
        bb.putInt(machine);
        bb.putInt(inc);
        return b;
    }

    @Override
    public String toString() {
        byte[] b = toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; i++) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }


}
