package com.sinosoftgz.starter.utils.lang;

/**
 * Created by Roney on 2020/11/4 15:38.
 * Base64格式的UUID(shortUuid) </br>
 * 由于Base64编码使用的字符包括大小写字母各26个，加上10个数字，和加号“+”，斜杠“/”，一共64个字符。所以才有Base64名字的由来。
 * Base64相当于使用64进制来表示数据，相同长度位数的情况下要比16进制表示更多的内容。 </br>
 */

import org.apache.commons.codec.binary.Base64;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;


public final class Uuids {
    private static UUIDGenerator generator = UUIDGenerator.getInstance();
    private static final int SHORT_UUID_LEN = 22;
    private static final int LONG_UUID_LEN = 32;
    private static final int UUID_SPLIT_POS_1 = 8;
    private static final int UUID_SPLIT_POS_2 = 13;
    private static final int UUID_SPLIT_POS_3 = 18;
    private static final int UUID_SPLIT_POS_4 = 23;

    private Uuids() {

    }

    /**
     * 获取长的Uuid字符串（通常为32位,即去掉横线）
     *
     * @return 长的Uuid字符串
     */
    public static String longUuid() {
        UUID uuid = generator.generateRandomBasedUUID();
        return uuid.toString().replace("-", "");
    }

    /**
     * 获取短的Uuid字符串（22位，可用作主键）
     *
     * @return 短的Uuid字符串
     */
    public static String shortUuid() {
        UUID uuid = generator.generateRandomBasedUUID();
        return compressedUUID(uuid);
    }

    private static String compressedUUID(UUID uuid) {
        return Base64.encodeBase64URLSafeString(uuid.asByteArray());
    }

    /**
     * 长UUID转为短UUID
     *
     * @param longUuid 长UUID
     * @return 短UUID
     */
    public static String longUuid2short(String longUuid) {
        if (longUuid.length() != LONG_UUID_LEN) {
            throw new IllegalArgumentException("Invalid uuid!" + longUuid);
        }
        // 按照格式添加-
        StringBuilder sb = new StringBuilder(longUuid);
        sb.insert(UUID_SPLIT_POS_1, '-');
        sb.insert(UUID_SPLIT_POS_2, '-');
        sb.insert(UUID_SPLIT_POS_3, '-');
        sb.insert(UUID_SPLIT_POS_4, '-');
        UUID uuid = UUID.valueOf(sb.toString());
        return compressedUUID(uuid);
    }

    /**
     * 短UUID转为长UUID
     *
     * @param shortUuid 短UUID
     * @return 长UUID
     */
    public static String shortUuid2long(String shortUuid) {
        if (shortUuid.length() != SHORT_UUID_LEN) {
            throw new IllegalArgumentException("Invalid uuid!" + shortUuid);
        }
        byte[] byUuid = Base64.decodeBase64(shortUuid + "==");
        UUID uuid = new UUID(byUuid);
        return uuid.toString().replace("-", "");
    }
}
