package com.sinosoftgz.starter.utils.web.enums;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by Roney on 2021/5/27 11:01.
 */
@AllArgsConstructor
@NoArgsConstructor
public enum UserPlatformType {

    MOBILE("mobile", "手机"),
    IPAD("ipad", "平板"),
    PC("PC", "PC");

    public static Map<String, UserPlatformType> businessTypeMap = new ConcurrentHashMap<>();

    static {
        businessTypeMap.put(MOBILE.getType(), MOBILE);
        businessTypeMap.put(IPAD.getType(), IPAD);
        businessTypeMap.put(PC.getType(), PC);
    }

    private String type;
    private String description;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
