package com.sinosoftgz.starter.utils.web.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 根据 user agent string 来判断出客户端的浏览器以及平台等信息
 * <p>
 * Created by Roney on 2019/3/26 16:50
 *
 * @author Roney
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserAgent {

    /**
     * 浏览器userAgent原文
     * <p>可通过request.getHeader("USER-AGENT").toLowerCase();获取</p>
     */
    private String userAgent;

    /**
     * 浏览器类型
     */
    private String browserType;

    /**
     * 平台类型
     */
    private String platformType;


    /**
     * 用来记录网页头信息
     */
    private String headMessage;

    /**
     * 用户平台类型 ipad,mobile,pc
     */
    private String userPlatformType;


}
