/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.date;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DDHHMM = "yyyy-MM-dd HH:mm";
    public static final String YYYYMMDDHHMMSS_CHINA = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String YYYY_MM_DD_HHMMSSSSS = "yyyy-MM-dd HH:mm:ss,SSS";

    private DateUtils() {
    }

    public static Days daysToNewYear(LocalDate fromDate) {
        LocalDate newYear = fromDate.plusYears(1).withDayOfYear(1);
        return Days.daysBetween((ReadablePartial)fromDate, (ReadablePartial)newYear);
    }

    public static String now(DateTime dateTime, String format) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        String dateTimeStr = formatter.print((ReadableInstant)dateTime);
        return dateTimeStr;
    }

    public static String now(String format) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        String dateTimeStr = formatter.print((ReadableInstant)new DateTime());
        return dateTimeStr;
    }

    public static String tomorrow(String format) {
        DateTime dateTime = new DateTime();
        dateTime = dateTime.plusDays(1);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        String dateTimeStr = formatter.print((ReadableInstant)dateTime);
        return dateTimeStr;
    }

    public static String nextYear(String format) {
        DateTime dateTime = new DateTime();
        dateTime = dateTime.plusYears(1);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        String dateTimeStr = formatter.print((ReadableInstant)dateTime);
        return dateTimeStr;
    }

    public static Date now() {
        DateTime dateTime = new DateTime();
        return dateTime.toDate();
    }

    public static Date startOfDay() {
        DateTime nowTime = new DateTime();
        DateTime startOfDay = nowTime.withTimeAtStartOfDay();
        return startOfDay.toDate();
    }

    public static Date endOfDay() {
        DateTime nowTime = new DateTime();
        DateTime endOfDay = nowTime.millisOfDay().withMaximumValue();
        return endOfDay.toDate();
    }

    public static LocalDateTime getDateTimeOfTimestamp(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }
}

