/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.lang;

import com.sinosoftgz.starter.utils.convert.Converter;
import com.sinosoftgz.starter.utils.convert.Converters;
import com.sinosoftgz.starter.utils.lang.Lang;
import com.sinosoftgz.starter.utils.lang.Maps;
import com.sinosoftgz.starter.utils.lang.Mirrors;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Copys {
    Set<String> includes = new HashSet<String>();
    Set<String> excludes = new HashSet<String>();
    Map<String, String> matchMap = Lang.newMap(new Object[0]);
    Map<String, Object> matchDefaultValueMap = Lang.newMap(new Object[0]);
    boolean caseSensitive = false;
    boolean includeNull = false;
    boolean includeEmpty = false;
    boolean includePrimitiveZero = false;
    boolean includePrimitiveFalse = false;
    Object from;
    List<Object> toList;
    Converters converters = Converters.create().extend(Converters.BASE);

    private Copys() {
    }

    public static Copys create() {
        return new Copys();
    }

    public <S, T> Copys converter(Class<S> fromType, Class<T> toType, Converter converter) {
        this.converters.add(fromType, toType, converter);
        return this;
    }

    public Copys match(String fromName, String toName, Object defaultValue) {
        this.matchMap.put(fromName, toName);
        this.matchDefaultValueMap.put(toName, defaultValue);
        return this;
    }

    public Copys match(String fromName, String toName) {
        return this.match(fromName, toName, null);
    }

    public Copys includeNull() {
        this.includeNull = true;
        return this;
    }

    public Copys excludeNull() {
        this.includeNull = false;
        return this;
    }

    public Copys includeEmpty() {
        this.includeEmpty = true;
        return this;
    }

    public Copys excludeEmpty() {
        this.includeEmpty = false;
        return this;
    }

    public Copys includePrimitiveFalse() {
        this.includePrimitiveFalse = true;
        return this;
    }

    public Copys excludePrimitiveFalse() {
        this.includePrimitiveFalse = false;
        return this;
    }

    public Copys includePrimitiveZero() {
        this.includePrimitiveZero = true;
        return this;
    }

    public Copys excludePrimitiveZero() {
        this.includePrimitiveZero = false;
        return this;
    }

    public Copys caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public Copys caseInsensitive() {
        this.caseSensitive = false;
        return this;
    }

    public Copys includes(String ... names) {
        for (String name : names) {
            if (name == null) continue;
            name = name.trim();
            this.includes.add(name);
            this.excludes.remove(name);
        }
        return this;
    }

    public Copys excludes(String ... names) {
        for (String name : names) {
            if (name == null) continue;
            name = name.trim();
            this.excludes.add(name);
            this.includes.remove(name);
        }
        return this;
    }

    public Copys from(Object from) {
        this.from = from;
        this.done();
        return this;
    }

    public Copys to(Object ... tos) {
        this.toList = Lang.newList(new Object[0]);
        for (Object to : tos) {
            if (to == null) continue;
            this.toList.add(to);
        }
        this.done();
        return this;
    }

    public Copys clear() {
        this.from = null;
        this.toList = null;
        return this;
    }

    private void done() {
        if (this.from == null || this.toList == null || this.toList.isEmpty()) {
            return;
        }
        Map<String, PropertyDescriptor> fromPropertyMap = this.caseSensitive ? Mirrors.getPropertyMap(this.from.getClass()) : Maps.caseInsensitiveMap(Mirrors.getPropertyMap(this.from.getClass()));
        for (Object to : this.toList) {
            if (to == null) continue;
            Map<String, PropertyDescriptor> toPropertyMap = this.caseSensitive ? Mirrors.getPropertyMap(to.getClass()) : Maps.caseInsensitiveMap(Mirrors.getPropertyMap(to.getClass()));
            for (String fromName : fromPropertyMap.keySet()) {
                PropertyDescriptor fromProperty;
                Method fromReadMethod;
                Method toWriteMethod;
                String toName;
                PropertyDescriptor toProperty;
                if (this.checkNull(fromName) || (toProperty = toPropertyMap.get(toName = (toName = this.matchMap.get(fromName)) == null ? fromName : toName)) == null || (toWriteMethod = toProperty.getWriteMethod()) == null || (fromReadMethod = (fromProperty = fromPropertyMap.get(fromName)).getReadMethod()) == null) continue;
                try {
                    Object fromValue = fromReadMethod.invoke(this.from, new Object[0]);
                    Object object = fromValue = fromValue != null ? fromValue : this.matchDefaultValueMap.get(toName);
                    if (fromValue == null && !this.includeNull || fromValue != null && Lang.isEmpty(fromValue) && !this.includeEmpty || fromValue != null && fromProperty.getPropertyType().isPrimitive() && (Lang.equals(fromValue, false) && !this.includePrimitiveFalse || Lang.equals(fromValue, 0) && !this.includePrimitiveZero)) continue;
                    Object toValue = fromValue == null ? null : this.converters.convert(fromValue, toProperty.getPropertyType());
                    toWriteMethod.invoke(to, toValue);
                }
                catch (Throwable e) {
                    throw Lang.unchecked(e, "Couldn't copy property %s with object %s to property %s with object %s", fromName, Lang.isBaseType(this.from.getClass()) ? this.from : ToStringBuilder.reflectionToString((Object)this.from), toName, Lang.isBaseType(to.getClass()) ? to : ToStringBuilder.reflectionToString((Object)to));
                }
            }
        }
    }

    private boolean checkNull(String fromName) {
        if (!this.includes.isEmpty() && !this.includes.contains(fromName)) {
            return true;
        }
        return this.excludes.contains(fromName);
    }
}

