/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.lang;

import com.sinosoftgz.starter.utils.lang.Lang;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.MethodUtils;
import org.springframework.util.AntPathMatcher;

public class Mirrors {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    private Mirrors() {
    }

    public static Class getGenricReturnType(Method method, int index) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType != null && genericReturnType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericReturnType).getActualTypeArguments()).length > index) {
            return (Class)actualTypeArguments[index];
        }
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Annotation> T getAnnotation(PropertyDescriptor propertyDescriptor, Class<T> annotationType) {
        Class<?> declaringClass;
        T annotation;
        T annotation2;
        Method readMethod = propertyDescriptor.getReadMethod();
        if (readMethod != null && (annotation2 = readMethod.getAnnotation(annotationType)) != null) {
            return annotation2;
        }
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod != null && (annotation = writeMethod.getAnnotation(annotationType)) != null) {
            return annotation;
        }
        Class<?> clazz = declaringClass = readMethod == null ? writeMethod.getDeclaringClass() : readMethod.getDeclaringClass();
        while (declaringClass != null) {
            try {
                Field field = declaringClass.getDeclaredField(propertyDescriptor.getName());
                T annotation3 = field.getAnnotation(annotationType);
                if (annotation3 == null) continue;
                T t = annotation3;
                return t;
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                declaringClass = declaringClass.getSuperclass();
            }
        }
        return null;
    }

    public static Field[] getFields(Class<? extends Object> type) {
        Set<Field> fields = Lang.newSet(new Field[0]);
        while (type != null) {
            for (Field field : type.getDeclaredFields()) {
                fields.add(field);
            }
            type = type.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    public static Map<String, PropertyDescriptor> getPropertyMap(Class<?> type) {
        Map<String, PropertyDescriptor> propertyDescriptors = Lang.newMap(new Object[0]);
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                if (propertyDescriptor.getPropertyType() == null || "class".equals(propertyDescriptor.getName())) continue;
                propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        catch (IntrospectionException e) {
            throw Lang.unchecked(e);
        }
        return propertyDescriptors;
    }

    public static PropertyDescriptor[] getPropertys(Class<?> type) {
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                if (propertyDescriptor.getPropertyType() == null || "class".equals(propertyDescriptor.getName())) continue;
                propertyDescriptors.add(propertyDescriptor);
            }
        }
        catch (IntrospectionException e) {
            throw Lang.unchecked(e);
        }
        return propertyDescriptors.toArray(new PropertyDescriptor[0]);
    }

    private static void handleProperty(String packagePattern, Object domain, PropertyHandler propertyHandler, Set<Integer> idHashs, String prefixPath) {
        if (domain == null) {
            return;
        }
        if (Lang.isBaseType(domain.getClass())) {
            return;
        }
        Integer id = System.identityHashCode(domain);
        if (idHashs.contains(id)) {
            return;
        }
        idHashs.add(id);
        if (domain instanceof Collection) {
            domain = ((Collection)domain).toArray();
        }
        if (domain.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(domain); ++i) {
                Mirrors.handleProperty(packagePattern, Array.get(domain, i), propertyHandler, idHashs, prefixPath.concat("[").concat(String.valueOf(i)).concat("]"));
            }
            return;
        }
        if (domain instanceof Map) {
            return;
        }
        if (!ANT_PATH_MATCHER.match(packagePattern.replace('.', '/'), domain.getClass().getPackage().getName().replace('.', '/'))) {
            return;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Mirrors.getPropertys(domain.getClass())) {
                Method readMethod;
                String newPath = prefixPath.concat(".").concat(propertyDescriptor.getName());
                propertyHandler.handle(newPath, domain, propertyDescriptor);
                if (Lang.isBaseType(propertyDescriptor.getPropertyType()) || (readMethod = propertyDescriptor.getReadMethod()) == null) continue;
                Mirrors.handleProperty(packagePattern, readMethod.invoke((Object)domain, new Object[0]), propertyHandler, idHashs, newPath);
            }
        }
        catch (Exception e) {
            throw Lang.unchecked(e);
        }
    }

    public static void handleProperty(String packagePattern, Object domain, PropertyHandler propertyHandler) {
        Mirrors.handleProperty(packagePattern, domain, propertyHandler, new HashSet<Integer>(), "$");
    }

    private static void handleField(String packagePattern, Object domain, FieldHandler fieldHandler, Set<Integer> idHashs, String prefixPath) {
        if (domain == null) {
            return;
        }
        if (Lang.isBaseType(domain.getClass())) {
            return;
        }
        Integer id = System.identityHashCode(domain);
        if (idHashs.contains(id)) {
            return;
        }
        idHashs.add(id);
        if (domain instanceof Collection) {
            domain = ((Collection)domain).toArray();
        }
        if (domain.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(domain); ++i) {
                Mirrors.handleField(packagePattern, Array.get(domain, i), fieldHandler, idHashs, prefixPath.concat("[").concat(String.valueOf(i)).concat("]"));
            }
            return;
        }
        if (domain instanceof Map) {
            return;
        }
        if (!ANT_PATH_MATCHER.match(packagePattern.replace('.', '/'), domain.getClass().getPackage().getName().replace('.', '/'))) {
            return;
        }
        try {
            Field[] fields;
            for (Field field : fields = Mirrors.getFields(domain.getClass())) {
                String newPath = prefixPath.concat(".").concat(field.getName());
                fieldHandler.handle(newPath, domain, field);
                if (Lang.isBaseType(field.getType())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Mirrors.handleField(packagePattern, field.get(domain), fieldHandler, idHashs, newPath);
            }
        }
        catch (Exception e) {
            throw Lang.unchecked(e);
        }
    }

    public static void handleField(String packagePattern, Object domain, FieldHandler fieldHandler) {
        Mirrors.handleField(packagePattern, domain, fieldHandler, new HashSet<Integer>(), "$");
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static float getTotalTransformationCost(Class<?>[] srcArgs, Class<?>[] destArgs) {
        if (srcArgs.length != destArgs.length) {
            return -1.0f;
        }
        float totalCost = 0.0f;
        for (int i = 0; i < srcArgs.length; ++i) {
            Class<?> destClass = destArgs[i];
            Class<?> srcClass = srcArgs[i];
            if (!MethodUtils.isAssignmentCompatible(destClass, srcClass)) {
                return -1.0f;
            }
            totalCost += Mirrors.getObjectTransformationCost(srcClass, destClass);
        }
        return totalCost;
    }

    private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        float cost = 0.0f;
        while (srcClass != null && !destClass.equals(srcClass)) {
            Class destClassWrapperClazz;
            if (destClass.isPrimitive() && (destClassWrapperClazz = MethodUtils.getPrimitiveWrapper(destClass)) != null && destClassWrapperClazz.equals(srcClass)) {
                cost += 0.25f;
                break;
            }
            if (destClass.isInterface() && MethodUtils.isAssignmentCompatible(destClass, srcClass)) {
                cost += 0.25f;
                break;
            }
            cost += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (srcClass == null) {
            cost += 1.5f;
        }
        return cost;
    }

    public static interface PropertyHandler {
        public void handle(String var1, Object var2, PropertyDescriptor var3);
    }

    public static interface FieldHandler {
        public void handle(String var1, Object var2, Field var3);
    }
}

