/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.security;

import com.sinosoftgz.starter.utils.security.Hex2Utils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils {
    private static Logger logger = LoggerFactory.getLogger(AESUtils.class);
    public static final int AES_LENGTH = 128;

    private AESUtils() {
    }

    public static String getKey(int length) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(length);
            SecretKey sk = kg.generateKey();
            byte[] b = sk.getEncoded();
            String s = Hex2Utils.parseByte2HexStr(b);
            return s;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String content, String password) {
        return AESUtils.aes(content, password, 1);
    }

    public static String decrypt(String content, String password) {
        return AESUtils.aes(content, password, 2);
    }

    private static String aes(String content, String password, int type) {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(password.getBytes());
            generator.init(128, random);
            SecretKey secretKey = generator.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(type, key);
            if (type == 1) {
                byte[] byteContent = content.getBytes("utf-8");
                return Hex2Utils.parseByte2HexStr(cipher.doFinal(byteContent));
            }
            byte[] byteContent = Hex2Utils.parseHexStr2Byte(content);
            return new String(cipher.doFinal(byteContent));
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

