/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.security;

import com.sinosoftgz.starter.utils.security.Hex2Utils;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DESUtils {
    private static Logger logger = LoggerFactory.getLogger(DESUtils.class);

    private DESUtils() {
    }

    public static String getKey(int length) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
            keyGenerator.init(length);
            SecretKey generateKey = keyGenerator.generateKey();
            byte[] encoded = generateKey.getEncoded();
            return Hex.encodeHexString((byte[])encoded);
        }
        catch (Exception e) {
            logger.error("\u5bc6\u94a5\u751f\u6210\u9519\u8bef:", (Throwable)e);
            return "\u5bc6\u94a5\u751f\u6210\u9519\u8bef.";
        }
    }

    public static String encrypt(String content, String password) {
        return DESUtils.des(content, password, 1);
    }

    public static String decrypt(String content, String password) {
        return DESUtils.des(content, password, 2);
    }

    private static String des(String content, String password, int type) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(type, (Key)keyFactory.generateSecret(desKey), random);
            if (type == 1) {
                byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
                return Hex2Utils.parseByte2HexStr(cipher.doFinal(byteContent));
            }
            byte[] byteContent = Hex2Utils.parseHexStr2Byte(content);
            assert (byteContent != null);
            return new String(cipher.doFinal(byteContent));
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }
}

