/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.security;

import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Utils {
    private static Logger logger = LoggerFactory.getLogger(MD5Utils.class);
    private static final String[] HEX_DIGIT = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private MD5Utils() {
    }

    public static String encrypt(String message) {
        try {
            return MD5Utils.encrypt(message, "MD5");
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String message, String algorithm) throws Exception {
        if (message == null) {
            throw new Exception("message is null.");
        }
        if (!"MD5".equals(algorithm) && !"SHA-1".equals(algorithm)) {
            throw new Exception("algorithm must be MD5 or SHA-1.");
        }
        byte[] buffer = message.getBytes();
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.reset();
        md.update(buffer);
        byte[] digest = md.digest();
        StringBuffer hexString = new StringBuffer();
        String sHexBit = null;
        for (int i = 0; i < digest.length; ++i) {
            sHexBit = Integer.toHexString(0xFF & digest[i]);
            if (sHexBit.length() == 1) {
                sHexBit = "0" + sHexBit;
            }
            hexString.append(sHexBit);
        }
        return hexString.toString();
    }

    public static String getMD5(byte[] source) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        return s;
    }

    public static String md5Encode(String origin, String charsetname) {
        String resultString = origin;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = charsetname == null || "".equals(charsetname) ? MD5Utils.byteArrayToHexString(md.digest(resultString.getBytes())) : MD5Utils.byteArrayToHexString(md.digest(resultString.getBytes(charsetname)));
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        return resultString;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(MD5Utils.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return HEX_DIGIT[d1] + HEX_DIGIT[d2];
    }
}

