/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.web;

import com.sinosoftgz.starter.utils.web.enums.UserPlatformType;
import com.sinosoftgz.starter.utils.web.vo.UserAgent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class UserAgentUtils {
    private static final String USER_AGENT = "USER-AGENT";
    private static final String PHONE_REG = "\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static final String TABLE_REG = "\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    public static final Map<String, String> PLATFORM_TYPE_MAP = new LinkedHashMap<String, String>(){
        {
            this.put("nexus", "\u5b89\u5353\u5e73\u677f");
            this.put("droid", "\u5b89\u5353\u5e73\u677f");
            this.put("xoom", "\u5b89\u5353\u5e73\u677f");
            this.put("playbook", "PlayBook");
            this.put("ipad", "ios\u5e73\u7248");
            this.put("iphone", "\u82f9\u679c\u624b\u673a");
            this.put("symbian", "\u585e\u73ed\u624b\u673a");
            this.put("windows phone", "winphone");
            this.put("android", "\u5b89\u5353\u624b\u673a");
            this.put("mobile", "\u624b\u673a\u7248");
            this.put("windows", "\u5fae\u8f6f\u7535\u8111");
            this.put("mac os x", "\u82f9\u679c\u7535\u8111");
        }
    };
    public static final Map<String, String> BROWSER_TYPE_MAP = new LinkedHashMap<String, String>(){
        {
            this.put("micromessenger", "\u5fae\u4fe1\u6d4f\u89c8\u5668");
            this.put("opera", "opera\u6d4f\u89c8\u5668");
            this.put("360se", "360\u6d4f\u89c8\u5668");
            this.put("qqbrowser", "QQ\u6d4f\u89c8\u5668");
            this.put("lbbrowser", "\u730e\u8c79\u6d4f\u89c8\u5668");
            this.put("baidubrowser", "\u767e\u5ea6\u6d4f\u89c8\u5668");
            this.put("bidubrowser", "\u767e\u5ea6\u6d4f\u89c8\u5668");
            this.put("baiduboxapp", "\u767e\u5ea6\u624b\u673aAPP");
            this.put("maxthon", "\u9068\u6e38\u6d4f\u89c8\u5668");
            this.put("sogoumobilebrowser", "\u641c\u72d7\u624b\u673a\u6d4f\u89c8\u5668");
            this.put("metasr", "\u641c\u72d7\u6d4f\u89c8\u5668");
            this.put("ucweb", "uc\u6d4f\u89c8\u5668");
            this.put("ucbrowser", "uc\u6d4f\u89c8\u5668");
            this.put("The World", "\u4e16\u754c\u4e4b\u7a97");
            this.put("avant", "AvantBrowser");
            this.put("tencenttraveler", "\u817e\u8bafTT");
            this.put("msie 8", "IE8\u6d4f\u89c8\u5668");
            this.put("msie", "IE\u6d4f\u89c8\u5668");
            this.put("firefox", "\u706b\u72d0");
            this.put("chrome", "\u8c37\u6b4c\u6d4f\u89c8\u5668");
            this.put("safari", "safari");
        }
    };

    private UserAgentUtils() {
    }

    public static UserAgent getUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT);
        return UserAgentUtils.getUserAgent(userAgent);
    }

    public static UserAgent getUserAgent(String userAgent) {
        if (StringUtils.isEmpty((Object)userAgent)) {
            return null;
        }
        String tUserAgent = userAgent.toLowerCase();
        String platformType = null;
        for (String key : PLATFORM_TYPE_MAP.keySet()) {
            if (!tUserAgent.contains(key)) continue;
            platformType = PLATFORM_TYPE_MAP.get(key);
            break;
        }
        UserAgent obj = UserAgentUtils.judgeBrowser(tUserAgent, platformType);
        return obj;
    }

    private static UserAgent judgeBrowser(String userAgent, String platformType) {
        UserAgent obj = new UserAgent();
        obj.setUserAgent(userAgent);
        obj.setPlatformType(platformType);
        String browserType = null;
        for (String key : BROWSER_TYPE_MAP.keySet()) {
            if (!userAgent.contains(key)) continue;
            browserType = BROWSER_TYPE_MAP.get(key);
            break;
        }
        obj.setBrowserType(browserType);
        obj.setHeadMessage(userAgent);
        UserAgentUtils.generatorBuyType(userAgent, obj);
        return obj;
    }

    private static void generatorBuyType(String userAgent, UserAgent obj) {
        Pattern phonePat = Pattern.compile(PHONE_REG, 2);
        Pattern tablePat = Pattern.compile(TABLE_REG, 2);
        Matcher matcherPhone = phonePat.matcher(userAgent);
        Matcher matcherTable = tablePat.matcher(userAgent);
        if (matcherTable.find()) {
            obj.setUserPlatformType(UserPlatformType.IPAD.getType());
        } else if (matcherPhone.find()) {
            obj.setUserPlatformType(UserPlatformType.MOBILE.getType());
        } else {
            obj.setUserPlatformType(UserPlatformType.PC.getType());
        }
    }
}

