/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.validation.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ValidationUtils {
    private static Validator validator = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false).buildValidatorFactory().getValidator();

    public static <T> ValidResult validateBean(T t, Class<?> ... groups) {
        ValidResult result = new ValidationUtils().new ValidResult();
        Set violationSet = validator.validate(t, (Class[])groups);
        boolean hasError = violationSet != null && violationSet.size() > 0;
        result.setHasErrors(hasError);
        if (hasError) {
            for (ConstraintViolation violation : violationSet) {
                result.addError(violation.getPropertyPath().toString(), violation.getMessage());
            }
        }
        return result;
    }

    public static <T> ValidResult validateProperty(T obj, String propertyName) {
        ValidResult result = new ValidationUtils().new ValidResult();
        Set violationSet = validator.validateProperty(obj, propertyName, new Class[0]);
        boolean hasError = violationSet != null && violationSet.size() > 0;
        result.setHasErrors(hasError);
        if (hasError) {
            for (ConstraintViolation violation : violationSet) {
                result.addError(propertyName, violation.getMessage());
            }
        }
        return result;
    }

    public class ErrorMessage {
        private String propertyPath;
        private String message;

        public ErrorMessage() {
        }

        public ErrorMessage(String propertyPath, String message) {
            this.propertyPath = propertyPath;
            this.message = message;
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        public String getMessage() {
            return this.message;
        }

        public void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorMessage)) {
                return false;
            }
            ErrorMessage other = (ErrorMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$propertyPath = this.getPropertyPath();
            String other$propertyPath = other.getPropertyPath();
            if (this$propertyPath == null ? other$propertyPath != null : !this$propertyPath.equals(other$propertyPath)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $propertyPath = this.getPropertyPath();
            result = result * 59 + ($propertyPath == null ? 43 : $propertyPath.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationUtils.ErrorMessage(propertyPath=" + this.getPropertyPath() + ", message=" + this.getMessage() + ")";
        }
    }

    public class ValidResult {
        private boolean hasErrors;
        private List<ErrorMessage> errors = new ArrayList<ErrorMessage>();

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public void setHasErrors(boolean hasErrors) {
            this.hasErrors = hasErrors;
        }

        public List<ErrorMessage> getAllErrors() {
            return this.errors;
        }

        public String getErrors() {
            StringBuilder sb = new StringBuilder();
            for (ErrorMessage error : this.errors) {
                sb.append(error.getPropertyPath()).append(":").append(error.getMessage()).append("\r\n");
            }
            return sb.toString();
        }

        public void addError(String propertyName, String message) {
            this.errors.add(new ErrorMessage(propertyName, message));
        }

        public boolean isHasErrors() {
            return this.hasErrors;
        }

        public void setErrors(List<ErrorMessage> errors) {
            this.errors = errors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidResult)) {
                return false;
            }
            ValidResult other = (ValidResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasErrors() != other.isHasErrors()) {
                return false;
            }
            String this$errors = this.getErrors();
            String other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !this$errors.equals(other$errors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValidResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasErrors() ? 79 : 97);
            String $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationUtils.ValidResult(hasErrors=" + this.isHasErrors() + ", errors=" + this.getErrors() + ")";
        }
    }
}

