package com.sinosoftgz.starter.validation.constraint;


import com.sinosoftgz.starter.validation.annotation.Timezone;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.TimeZone;

/**
 * Created by Roney on 2019/9/19.
 *
 * @author Roney
 * @date 2019-09-19 16:57
 */
public class TimezoneValidator implements ConstraintValidator<Timezone, String> {
    @Override
    public void initialize(Timezone timezone) {

    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return Arrays.asList(TimeZone.getAvailableIDs()).contains(value);
    }
}
