package com.sinosoftgz.starter.web.config;

import com.sinosoftgz.starter.web.converter.BaseResponseJackson2HttpMessageConverter;
import com.sinosoftgz.starter.web.interceptor.CommonInterceptor;
import com.sinosoftgz.starter.web.resource.ContentParaVersionStrategy;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.VersionResourceResolver;

import java.util.List;


/**
 * Created by Roney on 2021/1/14 11:53.
 */
@Configuration
public class WebConfiguration implements WebMvcConfigurer {


    @Bean
    @ConditionalOnMissingBean
    CommonInterceptor webCommonInterceptor() {
        return new CommonInterceptor();
    }


    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(webCommonInterceptor()).addPathPatterns("/**").excludePathPatterns("*.js", "*.css", "*.jpg", "*.png", "*.gif", "*.webp", "*.");
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**")
                .addResourceLocations("classpath:/META-INF/resources/"
                        , "classpath:/resources/", "classpath:/static/"
                        , "classpath:/public/")
                .setCachePeriod(365 * 24 * 3600 * 1000)
                // .setCacheControl(new CacheControl())
                .resourceChain(true).addResolver(new VersionResourceResolver()
                        .addVersionStrategy(new ContentParaVersionStrategy(), "/**"));
    }

    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(converter -> converter instanceof MappingJackson2HttpMessageConverter);
        converters.add(new BaseResponseJackson2HttpMessageConverter().jackson2HttpMessageConverter());
    }


}
