package com.sinosoftgz.starter.web.interceptor;

import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by Roney on 2021/1/14 11:56.
 */
@Component
public class CommonInterceptor extends HandlerInterceptorAdapter {

    private static final String CTX = "ctx";

    private static final String STATIC_CTX = "static_ctx";

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute(CTX, request.getContextPath());
        request.setAttribute(STATIC_CTX, request.getContextPath());
        return super.preHandle(request, response, handler);
    }
}
