/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.apollo.cache;

import com.sinosoftgz.starter.apollo.annotation.RefreshBean;
import com.sinosoftgz.starter.apollo.utils.ClassScannerUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
public class BeanCache
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BeanCache.class);
    private ApplicationContext applicationContext;
    private Map<String, Class> conditionalClassesMap = new ConcurrentHashMap<String, Class>();
    private Map<String, Class> refreshBeanClassesMap = new ConcurrentHashMap<String, Class>();

    @PostConstruct
    public void init() {
        for (String basePackage : this.listBasePackages()) {
            Set<Class> refreshBeanClasses;
            Set<Class> conditionalClasses = ClassScannerUtils.scan(basePackage, ConditionalOnProperty.class);
            if (!CollectionUtils.isEmpty(conditionalClasses)) {
                for (Class conditionalClass : conditionalClasses) {
                    String beanName = StringUtils.uncapitalize((String)conditionalClass.getSimpleName());
                    this.conditionalClassesMap.put(beanName, conditionalClass);
                }
            }
            if (CollectionUtils.isEmpty(refreshBeanClasses = ClassScannerUtils.scan(basePackage, RefreshBean.class))) continue;
            for (Class refreshBeanClass : refreshBeanClasses) {
                String beanName = StringUtils.uncapitalize((String)refreshBeanClass.getSimpleName());
                this.refreshBeanClassesMap.put(beanName, refreshBeanClass);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private List<String> listBasePackages() {
        ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)this.applicationContext;
        return AutoConfigurationPackages.get((BeanFactory)configurableContext.getBeanFactory());
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Map<String, Class> getConditionalClassesMap() {
        return this.conditionalClassesMap;
    }

    public Map<String, Class> getRefreshBeanClassesMap() {
        return this.refreshBeanClassesMap;
    }
}

