package com.sinosoftgz.starter.apollo.api;

/**
 * Created by Roney on 2020/11/3 15:25.
 */


import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.sinosoftgz.starter.apollo.constants.ApolloConfigConstants;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping(ApolloConfigConstants.APP_BASE_CONTEXT + "/jasypt")
public class JasyptToolController {
    private static final Logger log = LoggerFactory.getLogger(JasyptToolController.class);
    @Autowired
    private StringEncryptor stringEncryptor;

    @RequestMapping(value = "/encrypt", method = RequestMethod.POST)
    @ResponseBody
    public String encrypt(@RequestParam(name = "text", required = true) String text, @RequestParam(name = "initKey", required = true) String initKey) {
        if (StringUtils.isEmpty(encryptorKey)) {
            return null;
        }
        if (!initKey.equals(encryptorKey)) {
            log.info("密码错误:{} ", initKey);
            return null;
        }
        if (StringUtils.isEmpty(text)) {
            log.info("原文不能为空:{} ", text);
            return null;
        }
        String encrypted = stringEncryptor.encrypt(text.trim());
        log.info("原文:{} ", text);
        log.info("加密: {}", encrypted);

        log.info("最终需要的加密串: {}", String.format("ENC(%s)", encrypted));
        return String.format("ENC(%s)", encrypted);
    }


    @Value("${spring.datasource.username:tpmall}")
    private String databaseUsername;
    @Value("${spring.datasource.password:tpmall}")
    private String databasePassword;
    @Value("${jasypt.encryptor.password:TPMALLUHYSGDN#*@#%}")
    private String encryptorKey;

    @RequestMapping(value = "/getDatabaseInfo", method = RequestMethod.POST)
    public void getDatabaseInfo(@RequestParam(name = "initKey", required = true) String initKey) {
        if (StringUtils.isEmpty(encryptorKey)) {
            return;
        }
        if (!initKey.equals(encryptorKey)) {
            log.info("密码错误:{} ", initKey);
            return;
        }
        log.info("encryptorKey:{},username:{}, password:{}", encryptorKey, databaseUsername, databasePassword);
    }

}


