package com.sinosoftgz.starter.apollo.config;

import com.sinosoftgz.starter.apollo.api.RefreshBeanController;
import com.sinosoftgz.starter.apollo.cache.BeanCache;
import com.sinosoftgz.starter.apollo.refresh.*;
import com.sinosoftgz.starter.apollo.api.JasyptToolController;
import com.sinosoftgz.starter.apollo.properties.InsConfigProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * Created by Roney on 2019/8/19.
 *
 * @author Roney
 * @date 2019-08-19 09:57
 */
@Configuration
@EnableConfigurationProperties({InsConfigProperties.class})
@Import({
        JasyptToolController.class,
        RefreshBeanController.class,
        ConfigPropertiesRefreshConfig.class,
        ConfigPropertiesListenerConfig.class,
        Log4j2ListenerConfig.class,
        LoggerRefreshConfig.class,
        EnvironmentChangeEventRefreshConfig.class,
        EnvironmentChangeEventListenerConfig.class,
        ConditionalOnPropertyRefreshConfig.class,
        ConditionalOnPropertyListenerConfig.class
})
@ConditionalOnProperty(prefix = InsConfigProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class InsConfigConfiguration {

    private InsConfigProperties insConfigProperties;

    public InsConfigConfiguration(final InsConfigProperties insConfigProperties) {
        this.insConfigProperties = insConfigProperties;
    }

    @Bean
    BeanCache beanCache() {
        return new BeanCache();
    }

}
