package com.sinosoftgz.starter.apollo.constants;

/**
 * 配置中心常用变量
 * Created by Roney on 2021/4/16 16:50.
 */
public abstract class ApolloConfigConstants {

    /**
     * http接口统一上下文
     */
    public static final String APP_BASE_CONTEXT = "/apollo";

    /**
     * 机构前缀
     */
    private static final String ORG_ID = "OrgId0.";

    /**
     * RPC_MOTAN
     */
    public static final String NAMESPACE_RPC_MOTAN = ORG_ID + "motan";
    /**
     * RPC_DUBBO
     */
    public static final String NAMESPACE_RPC_DUBBO = ORG_ID + "dubbo";
    /**
     * RPC_SPRING_CLOUD
     */
    public static final String NAMESPACE_RPC_SPRING_CLOUD = ORG_ID + "spring-cloud";
    /**
     * RPC_TARS
     */
    public static final String NAMESPACE_RPC_TARS = ORG_ID + "Tars";
    /**
     * RPC_GRPC
     */
    public static final String NAMESPACE_RPC_GRPC = ORG_ID + "gRPC";
    /**
     * RPC_THRIFT
     */
    public static final String NAMESPACE_RPC_THRIFT = ORG_ID + "Thrift";
    /**
     * rocketmq
     */
    public static final String NAMESPACE_MQ_ROCKETMQ = ORG_ID + "rocketmq";

    /**
     * activemq
     */
    public static final String NAMESPACE_MQ_ACTIVEMQ = ORG_ID + "activemq";


}
