package com.sinosoftgz.starter.apollo.properties;

import com.ctrip.framework.apollo.core.ConfigConsts;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.annotation.PostConstruct;
import java.util.Optional;

/**
 * Created by Roney on 2019/8/19.
 *
 * @author Roney
 * @date 2019-08-19 09:43
 */
@ConfigurationProperties(prefix = InsConfigProperties.CONFIG_PREFIX)
@Data
public class InsConfigProperties {

    public static final String CONFIG_PREFIX = "ins.config";

    private static final String COMMA = ",";

    /**
     * 是否开启自动刷新机制
     * 开启自动刷新，则支持所有的类型
     */
    private boolean enabled;
    /**
     * 刷新的bean名称，多个用英文,隔开
     * 强制要求客户端配置，防止像数据库、redis等重要组件被强制刷新
     */
    private String toRefreshBeanNames;

    /**
     * 开启变化日志打印
     * 默认开启,线上环境建议开启
     */
    private boolean enabledLog = true;


    /**
     * 刷新的Namespace名称，多个用英文,隔开
     */
    public static String toRefreshNamespaces = ConfigConsts.NAMESPACE_APPLICATION;

    /**
     * 刷新的Namespace数组
     */
    public static final String NAMESPACES_VALUE = toRefreshNamespaces;


    @Value("${apollo.bootstrap.namespaces}")
    public void setToRefreshNamespaces(String toRefreshNamespaces) {
        InsConfigProperties.toRefreshNamespaces = toRefreshNamespaces;
    }

    public Optional<String[]> toRefreshBeanNameArray() {
        if (this.toRefreshBeanNames == null) {
            return Optional.empty();
        } else {
            String trimToRefreshBeanNames = this.toRefreshBeanNames.trim();
            String[] toRefreshBeanNameArray = trimToRefreshBeanNames.split(COMMA);
            return Optional.of(toRefreshBeanNameArray);
        }
    }

    @PostConstruct
    public void init() {
        // NAMESPACES_VALUE = toRefreshNamespaces.split(COMMA);
    }


}
