package com.sinosoftgz.starter.apollo.refresh;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

/**
 * Created by Roney on 2020/12/1 14:22.
 */
@Configuration
@EnableApolloConfig
@Slf4j
public class ConditionalOnPropertyListenerConfig {

    @ApolloConfig
    private Config apolloConfig;


    public ConditionalOnPropertyListenerConfig() {
    }

    @ApolloConfigChangeListener
    private void onChange(ConfigChangeEvent changeEvent) {
        this.refreshConfigProperties();
    }

    @PostConstruct
    private void refreshConfigProperties() {
        log.debug("the property names", this.apolloConfig.getPropertyNames());
    }
}
