package com.sinosoftgz.starter.apollo.refresh;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.sinosoftgz.starter.apollo.utils.LogChangeKeyUtils;
import com.sinosoftgz.starter.apollo.properties.InsConfigProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Optional;

/**
 * Created by Roney on 2019/8/19.
 * 基于RefreshScope实现刷新
 *
 * @author Roney
 * @date 2019-08-19 09:48
 */
@Component
@Slf4j
public class ConfigPropertiesRefreshConfig {
    private static final String LOG_TITLE = "基于RefreshScope实现刷新";
    private final RefreshScope refreshScope;
    private final InsConfigProperties insConfigProperties;

    public ConfigPropertiesRefreshConfig(final InsConfigProperties insConfigProperties, final RefreshScope refreshScope) {
        this.insConfigProperties = insConfigProperties;
        this.refreshScope = refreshScope;
    }

    @ApolloConfigChangeListener()
    public void onChange(final ConfigChangeEvent changeEvent) {
        log.info(LOG_TITLE + " The to refresh bean name is {}. ", this.insConfigProperties.getToRefreshBeanNames());
        Optional<String[]> beanArrayOptional = this.insConfigProperties.toRefreshBeanNameArray();
        if (beanArrayOptional.isPresent()) {
            Arrays.stream((Object[]) beanArrayOptional.get()).forEach((beanName) -> {
                this.refreshScope.refresh((String) beanName);
            });
            LogChangeKeyUtils.printChange(LOG_TITLE, insConfigProperties.isEnabledLog(), changeEvent);
        }

    }
}
