package com.sinosoftgz.starter.apollo.refresh;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.sinosoftgz.starter.apollo.utils.LogChangeKeyUtils;
import com.sinosoftgz.starter.apollo.properties.InsConfigProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * Created by Roney on 2020/12/1 14:01.
 * 基于EnvironmentChangeEvent实现刷新
 */
@Component
@Slf4j
public class EnvironmentChangeEventRefreshConfig implements ApplicationContextAware {
    private static final String LOG_TITLE = "基于EnvironmentChangeEvent实现刷新";

    /**
     * spring控制器
     */
    private ApplicationContext applicationContext;


    private final InsConfigProperties insConfigProperties;

    public EnvironmentChangeEventRefreshConfig(final InsConfigProperties insConfigProperties, final ApplicationContext applicationContext) {
        this.insConfigProperties = insConfigProperties;
        this.applicationContext = applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ApolloConfigChangeListener
    public void onChange(final ConfigChangeEvent changeEvent) {
        log.info(LOG_TITLE + " The to refresh bean name is {}. ", this.insConfigProperties.getToRefreshBeanNames());
        Optional<String[]> beanArrayOptional = this.insConfigProperties.toRefreshBeanNameArray();
        if (beanArrayOptional.isPresent()) {
            this.applicationContext.publishEvent(new EnvironmentChangeEvent(changeEvent.changedKeys()));
            LogChangeKeyUtils.printChange(LOG_TITLE, insConfigProperties.isEnabledLog(), changeEvent);
        }

    }

}
