package com.sinosoftgz.starter.apollo.refresh;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

/**
 * Created by Roney on 2019/8/19.
 *
 * @author Roney
 * @date 2019-08-19 09:54
 */
@Configuration
@EnableApolloConfig
public class Log4j2ListenerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(Log4j2ListenerConfig.class);
    @ApolloConfig
    private Config apolloConfig;
    private static final String APOLLO_LOGGER_LEVER_KEY = "log4j2.log.level";

    public Log4j2ListenerConfig() {
    }

    @ApolloConfigChangeListener
    private void onChange(ConfigChangeEvent changeEvent) {
        this.refreshLoggerLever();
    }

    @PostConstruct
    private void refreshLoggerLever() {
        String level = this.apolloConfig.getProperty(APOLLO_LOGGER_LEVER_KEY, "INFO");
        LOGGER.warn("日志级别已切换,当前级别:[{}]", level);
    }
}
