package com.sinosoftgz.starter.apollo.refresh;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Iterator;
import java.util.Set;

/**
 * Created by Roney on 2019/8/19.
 *
 * @author Roney
 * @date 2019-08-19 09:56
 */
@Component
public class LoggerRefreshConfig {
    private static final Logger logger = LoggerFactory.getLogger(LoggerRefreshConfig.class);
    private static final String LOGGER_TAG = "logging.level.";
    @Autowired
    private LoggingSystem loggingSystem;
    @ApolloConfig
    private Config config;

    public LoggerRefreshConfig() {
    }

    @ApolloConfigChangeListener
    private void loggerConfigChangeListener(ConfigChangeEvent changeEvent) {
        this.refreshLoggingLevels();
    }

    @PostConstruct
    private void refreshLoggingLevels() {
        Set<String> keyNames = this.config.getPropertyNames();
        Iterator var2 = keyNames.iterator();

        while (var2.hasNext()) {
            String key = (String) var2.next();
            if (containsIgnoreCase(key, LOGGER_TAG)) {
                String strLevel = this.config.getProperty(key, "info");
                LogLevel level = LogLevel.valueOf(strLevel.toUpperCase());
                this.loggingSystem.setLogLevel(key.replace(LOGGER_TAG, "").toUpperCase(), level);
                logger.info("{}:{}", key, strLevel);
            }
        }

    }

    private static boolean containsIgnoreCase(String str, String searchStr) {
        if (str != null && searchStr != null) {
            int len = searchStr.length();
            int max = str.length() - len;

            for (int i = 0; i <= max; ++i) {
                if (str.regionMatches(true, i, searchStr, 0, len)) {
                    return true;
                }
            }

            return false;
        } else {
            return false;
        }
    }
}
