package com.sinosoftgz.starter.apollo.utils;

import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * Created by Roney on 2020/12/1 18:09.
 */
@Slf4j
public class LogChangeKeyUtils {
    /**
     * 打印变化信息
     *
     * @param title
     * @param changeEvent
     */
    public static void printChange(String title, boolean enabledLog, ConfigChangeEvent changeEvent) {
        if (enabledLog) {
            Set<String> changeKeys = changeEvent.changedKeys();
            if (!CollectionUtils.isEmpty(changeKeys)) {
                for (String changeKey : changeKeys) {
                    ConfigChange change = changeEvent.getChange(changeKey);
                    log.info(
                            "title : {} Found change - key: {}, oldValue: {}, newValue: {}, changeType: {}",
                            title,
                            change.getPropertyName(), change.getOldValue(),
                            change.getNewValue(), change.getChangeType());
                }
            }
        }
    }
}
