/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.apollo.properties;

import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="ins.config")
public class InsConfigProperties {
    public static final String CONFIG_PREFIX = "ins.config";
    private static final String COMMA = ",";
    private boolean enabled;
    private String toRefreshBeanNames;
    private boolean enabledLog = true;
    public static String toRefreshNamespaces;
    public static final String NAMESPACES_VALUE;

    @Value(value="${apollo.bootstrap.namespaces}")
    public void setToRefreshNamespaces(String toRefreshNamespaces) {
        InsConfigProperties.toRefreshNamespaces = toRefreshNamespaces;
    }

    public Optional<String[]> toRefreshBeanNameArray() {
        if (this.toRefreshBeanNames == null) {
            return Optional.empty();
        }
        String trimToRefreshBeanNames = this.toRefreshBeanNames.trim();
        String[] toRefreshBeanNameArray = trimToRefreshBeanNames.split(COMMA);
        return Optional.of(toRefreshBeanNameArray);
    }

    @PostConstruct
    public void init() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getToRefreshBeanNames() {
        return this.toRefreshBeanNames;
    }

    public boolean isEnabledLog() {
        return this.enabledLog;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setToRefreshBeanNames(String toRefreshBeanNames) {
        this.toRefreshBeanNames = toRefreshBeanNames;
    }

    public void setEnabledLog(boolean enabledLog) {
        this.enabledLog = enabledLog;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsConfigProperties)) {
            return false;
        }
        InsConfigProperties other = (InsConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isEnabledLog() != other.isEnabledLog()) {
            return false;
        }
        String this$toRefreshBeanNames = this.getToRefreshBeanNames();
        String other$toRefreshBeanNames = other.getToRefreshBeanNames();
        return !(this$toRefreshBeanNames == null ? other$toRefreshBeanNames != null : !this$toRefreshBeanNames.equals(other$toRefreshBeanNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InsConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnabledLog() ? 79 : 97);
        String $toRefreshBeanNames = this.getToRefreshBeanNames();
        result = result * 59 + ($toRefreshBeanNames == null ? 43 : $toRefreshBeanNames.hashCode());
        return result;
    }

    public String toString() {
        return "InsConfigProperties(enabled=" + this.isEnabled() + ", toRefreshBeanNames=" + this.getToRefreshBeanNames() + ", enabledLog=" + this.isEnabledLog() + ")";
    }

    static {
        NAMESPACES_VALUE = toRefreshNamespaces = "application";
    }
}

