/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.apollo.refresh;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.sinosoftgz.starter.apollo.properties.InsConfigProperties;
import com.sinosoftgz.starter.apollo.utils.LogChangeKeyUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentChangeEventRefreshConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentChangeEventRefreshConfig.class);
    private static final String LOG_TITLE = "\u57fa\u4e8eEnvironmentChangeEvent\u5b9e\u73b0\u5237\u65b0";
    private ApplicationContext applicationContext;
    private final InsConfigProperties insConfigProperties;

    public EnvironmentChangeEventRefreshConfig(InsConfigProperties insConfigProperties, ApplicationContext applicationContext) {
        this.insConfigProperties = insConfigProperties;
        this.applicationContext = applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ApolloConfigChangeListener
    public void onChange(ConfigChangeEvent changeEvent) {
        log.info("\u57fa\u4e8eEnvironmentChangeEvent\u5b9e\u73b0\u5237\u65b0 The to refresh bean name is {}. ", (Object)this.insConfigProperties.getToRefreshBeanNames());
        Optional<String[]> beanArrayOptional = this.insConfigProperties.toRefreshBeanNameArray();
        if (beanArrayOptional.isPresent()) {
            this.applicationContext.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(changeEvent.changedKeys()));
            LogChangeKeyUtils.printChange(LOG_TITLE, this.insConfigProperties.isEnabledLog(), changeEvent);
        }
    }
}

