/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.apollo.refresh;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.stereotype.Component;

@Component
public class LoggerRefreshConfig {
    private static final Logger logger = LoggerFactory.getLogger(LoggerRefreshConfig.class);
    private static final String LOGGER_TAG = "logging.level.";
    @Autowired
    private LoggingSystem loggingSystem;
    @ApolloConfig
    private Config config;

    @ApolloConfigChangeListener
    private void loggerConfigChangeListener(ConfigChangeEvent changeEvent) {
        this.refreshLoggingLevels();
    }

    @PostConstruct
    private void refreshLoggingLevels() {
        Set keyNames = this.config.getPropertyNames();
        for (String key : keyNames) {
            if (!LoggerRefreshConfig.containsIgnoreCase(key, LOGGER_TAG)) continue;
            String strLevel = this.config.getProperty(key, "info");
            LogLevel level = LogLevel.valueOf((String)strLevel.toUpperCase());
            this.loggingSystem.setLogLevel(key.replace(LOGGER_TAG, "").toUpperCase(), level);
            logger.info("{}:{}", (Object)key, (Object)strLevel);
        }
    }

    private static boolean containsIgnoreCase(String str, String searchStr) {
        if (str != null && searchStr != null) {
            int len = searchStr.length();
            int max = str.length() - len;
            for (int i = 0; i <= max; ++i) {
                if (!str.regionMatches(true, i, searchStr, 0, len)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

