/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jdbc.utils;

import cn.hutool.core.util.StrUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sinosoftgz.starter.utils.core.NamingUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlBuilderUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlBuilderUtils.class);

    public static String buildTableName(String tableName) {
        return "`" + tableName.replaceAll("#", "") + "`";
    }

    public static Pair<String, Object[]> buildInsert(String tableName, Map<String, Object> map) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(SqlBuilderUtils.buildTableName(tableName)).append("(");
        StringBuffer field = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            field.append(NamingUtils.camelToUnderline((String)entry.getKey())).append(",");
            params.add(entry.getValue());
        }
        sql.append(field.deleteCharAt(field.length() - 1));
        sql.append(") VALUES (");
        sql.append(SqlBuilderUtils.buildQuestion(map));
        sql.append(");");
        SqlBuilderUtils.logSql(sql.toString());
        return new Pair((Object)sql.toString(), (Object)params.toArray());
    }

    public static String buildQuestion(Map<String, Object> mapItem) {
        if (MapUtils.isNotEmpty(mapItem)) {
            String questionList = StringUtils.repeat((String)"?,", (int)mapItem.size());
            if (questionList.endsWith(",")) {
                questionList = questionList.substring(0, questionList.length() - 1);
            }
            return questionList;
        }
        return "";
    }

    public static Pair<String, List<Object[]>> buildBatchInsert(String tableName, List<Map<String, Object>> listData) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        ArrayList listObjs = Lists.newArrayList();
        ArrayList listKeys = Lists.newArrayList();
        ArrayList listCommas = Lists.newArrayList();
        boolean flagSetKeys = false;
        for (Map<String, Object> mapItem : listData) {
            listObjs.clear();
            if (!flagSetKeys) {
                listKeys.clear();
                listCommas.clear();
            }
            for (Map.Entry<String, Object> entry : mapItem.entrySet()) {
                listObjs.add(entry.getValue());
                if (flagSetKeys) continue;
                listKeys.add("`" + NamingUtils.camelToUnderline((String)entry.getKey()) + "`");
                listCommas.add("?");
            }
            flagSetKeys = true;
            parameters.add(listObjs.toArray());
        }
        String sql = StrUtil.format((CharSequence)"INSERT INTO `{}` ({}) VALUES ({})", (Object[])new Object[]{tableName, Joiner.on((String)",").join((Iterable)listKeys), Joiner.on((String)",").join((Iterable)listCommas)});
        SqlBuilderUtils.logSql(sql);
        return new Pair((Object)sql, parameters);
    }

    public static Pair<String, Object[]> buildUpdateSql(String tableName, Map<String, Object> map, LinkedHashMap<String, Object> whereMap) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("UPDATE ").append(SqlBuilderUtils.buildTableName(tableName)).append(" SET ");
        StringBuffer temp = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            temp.append(NamingUtils.camelToUnderline((String)entry.getKey())).append("=").append("?,");
            params.add(entry.getValue());
        }
        sql.append(temp.deleteCharAt(temp.length() - 1));
        if (whereMap != null) {
            sql.append(" WHERE 1=1 ");
            for (Map.Entry<String, Object> entry : whereMap.entrySet()) {
                sql.append(" AND ").append(NamingUtils.camelToUnderline((String)entry.getKey())).append("=").append("?");
                params.add(entry.getValue());
            }
        }
        SqlBuilderUtils.logSql(sql.toString());
        return new Pair((Object)sql.toString(), (Object)params.toArray());
    }

    private static void logSql(String sql) {
        log.info("sql:{}", (Object)sql);
    }

    public static String buildFields(String[] fields) {
        StringBuffer sql = new StringBuffer();
        if (null != fields && fields.length > 0 && fields != null && fields.length > 0) {
            for (String field : fields) {
                sql.append(NamingUtils.camelToUnderline((String)field)).append(",");
            }
            sql.deleteCharAt(sql.length() - 1);
        }
        return sql.toString();
    }

    public static String buildFieldsWithQuestion(String[] fields) {
        StringBuffer sql = new StringBuffer();
        if (null != fields && fields.length > 0) {
            for (String field : fields) {
                sql.append(NamingUtils.camelToUnderline((String)field)).append("=").append("?,");
            }
            sql.deleteCharAt(sql.length() - 1);
        }
        return sql.toString();
    }

    public static String buildQuestion(String[] fields) {
        String questionList = StringUtils.repeat((String)"?,", (int)fields.length);
        if (questionList.endsWith(",")) {
            questionList = questionList.substring(0, questionList.length() - 1);
        }
        return questionList;
    }

    public static String buildCountSql(String tableName, String countStr, Map<String, String> where) {
        if (StringUtils.isEmpty((CharSequence)countStr)) {
            throw new RuntimeException("\u5b9e\u4f53\u7f3a\u5c11\u4e3b\u8868\u522b\u540d");
        }
        StringBuilder sql = new StringBuilder(" SELECT COUNT(" + countStr + ") FROM " + tableName);
        sql.append(SqlBuilderUtils.buildWhere(where));
        return sql.toString().trim();
    }

    public static String buildWhere(Map<String, String> whereMap) {
        StringBuffer sql = new StringBuffer(" WHERE 1=1");
        if (MapUtils.isNotEmpty(whereMap)) {
            sql.append(" WHERE 1=1 ");
            for (Map.Entry<String, String> me : whereMap.entrySet()) {
                String columnName = me.getKey();
                String columnValue = me.getValue();
                sql.append(" AND ").append(NamingUtils.camelToUnderline((String)columnName)).append(" ").append(columnValue);
            }
        }
        return sql.toString();
    }
}

