/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jdbc.page;

import com.github.drinkjava2.jdialects.Dialect;
import com.sinosoftgz.global.common.request.page.PageQueryRequest;
import com.sinosoftgz.global.common.response.page.ResultPage;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class JdbcPageUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcPageUtils.class);
    private JdbcTemplate jdbcTemplate;

    public JdbcPageUtils(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public <T> ResultPage<T> query(@NotNull String sql, @NotNull Class<T> elementType, @NotNull PageQueryRequest pageQueryRequest, Map<String, Object> args) {
        long time = System.currentTimeMillis();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.jdbcTemplate.getDataSource());
        SqlReCreateFactory sqlReCreateFactory = new SqlReCreateFactory(sql, pageQueryRequest.getPageNum(), pageQueryRequest.getPageSize(), args).invoke();
        sql = sqlReCreateFactory.getSql();
        ResultPage resultPage = sqlReCreateFactory.getResultPage();
        log.debug("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u8017\u65f6------\uff1a{} ms", (Object)(System.currentTimeMillis() - time));
        long startTime = System.currentTimeMillis();
        List result = namedParameterJdbcTemplate.query(sql, args, (RowMapper)new BeanPropertyRowMapper(elementType));
        log.debug("\u6267\u884c\u67e5\u8be2sql\u8017\u65f6------\uff1a{} ms", (Object)(System.currentTimeMillis() - startTime));
        resultPage.setData(result);
        return resultPage;
    }

    public ResultPage query(@NotNull String sql, @NotNull PageQueryRequest pageQueryRequest, Map<String, Object> args) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.jdbcTemplate.getDataSource());
        SqlReCreateFactory sqlReCreateFactory = new SqlReCreateFactory(sql, pageQueryRequest.getPageNum(), pageQueryRequest.getPageSize(), args).invoke();
        sql = sqlReCreateFactory.getSql();
        ResultPage resultPage = sqlReCreateFactory.getResultPage();
        List result = namedParameterJdbcTemplate.queryForList(sql, args);
        resultPage.setData(result);
        return resultPage;
    }

    private class SqlReCreateFactory<T> {
        private String sql;
        private int pageNum;
        private int pageSize;
        private Map<String, Object> args;
        private ResultPage<T> resultPage;

        public SqlReCreateFactory(String sql, int pageNum, int pageSize, Map<String, Object> args) {
            this.sql = sql;
            this.pageNum = pageNum;
            this.pageSize = pageSize;
            this.args = args;
        }

        public SqlReCreateFactory invoke() {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(JdbcPageUtils.this.jdbcTemplate.getDataSource());
            this.resultPage = new ResultPage(new Long(0L).longValue(), new Long(this.pageSize).longValue());
            String sqlCount = "select count(*) from (" + this.sql + ")  count_table";
            Integer count = (Integer)namedParameterJdbcTemplate.queryForObject(sqlCount, this.args, Integer.class);
            this.resultPage.setTotalCount((long)count.intValue());
            int pageNum = 0;
            if (count != null && count > 0) {
                pageNum = count % this.pageSize == 0 ? count / this.pageSize : count / this.pageSize + 1;
                this.resultPage.setPageNo((long)pageNum);
            }
            Dialect dialect = Dialect.guessDialect((DataSource)JdbcPageUtils.this.jdbcTemplate.getDataSource());
            this.sql = dialect.pagin(this.pageNum, this.pageSize, this.sql);
            log.info("sql:{}", (Object)this.sql);
            return this;
        }

        public String getSql() {
            return this.sql;
        }

        public int getPageNum() {
            return this.pageNum;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public Map<String, Object> getArgs() {
            return this.args;
        }

        public ResultPage<T> getResultPage() {
            return this.resultPage;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setPageNum(int pageNum) {
            this.pageNum = pageNum;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public void setArgs(Map<String, Object> args) {
            this.args = args;
        }

        public void setResultPage(ResultPage<T> resultPage) {
            this.resultPage = resultPage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SqlReCreateFactory)) {
                return false;
            }
            SqlReCreateFactory other = (SqlReCreateFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPageNum() != other.getPageNum()) {
                return false;
            }
            if (this.getPageSize() != other.getPageSize()) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            Map<String, Object> this$args = this.getArgs();
            Map<String, Object> other$args = other.getArgs();
            if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
                return false;
            }
            ResultPage<T> this$resultPage = this.getResultPage();
            ResultPage<T> other$resultPage = other.getResultPage();
            return !(this$resultPage == null ? other$resultPage != null : !this$resultPage.equals(other$resultPage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SqlReCreateFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPageNum();
            result = result * 59 + this.getPageSize();
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            Map<String, Object> $args = this.getArgs();
            result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
            ResultPage<T> $resultPage = this.getResultPage();
            result = result * 59 + ($resultPage == null ? 43 : $resultPage.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcPageUtils.SqlReCreateFactory(sql=" + this.getSql() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", args=" + this.getArgs() + ", resultPage=" + this.getResultPage() + ")";
        }
    }
}

