/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jdbc.utils;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import com.sinosoftgz.starter.jdbc.utils.SqlBuilderUtils;
import com.sinosoftgz.starter.utils.lang.NamingUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class JdbcTemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcTemplateUtils.class);
    private JdbcTemplate jdbcTemplate;

    public JdbcTemplateUtils(JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, "");
    }

    public JdbcTemplateUtils(JdbcTemplate jdbcTemplate, @NotNull String tableName) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Integer insert(@NotNull String tableName, Map<String, Object> map) {
        Pair<String, Object[]> pair = SqlBuilderUtils.buildInsert(tableName, map);
        return this.getJdbcTemplate().update((String)pair.getKey(), (Object[])pair.getValue());
    }

    public int[] batchInsert(@NotNull String tableName, List<Map<String, Object>> listData) {
        Pair<String, List<Object[]>> pair = SqlBuilderUtils.buildBatchInsert(tableName, listData);
        return this.jdbcTemplate.batchUpdate((String)pair.getKey(), (List)pair.getValue());
    }

    public void batchInsert(@NotNull String tableName, String[] fields, List<Map<String, Object>> list) throws Exception {
        this.batchInsert(tableName, fields, list, false);
    }

    public void batchInsert(@NotNull String tableName, final String[] fields, final List<Map<String, Object>> list, boolean ignore) {
        StringBuffer sql = new StringBuffer("insert ").append(ignore ? " ignore into " : " into ").append(tableName).append(" (").append(SqlBuilderUtils.buildFields(fields)).append(") values (").append(SqlBuilderUtils.buildQuestion(fields)).append(");");
        this.getJdbcTemplate().batchUpdate(sql.toString(), new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                int len = fields.length;
                for (int j = 0; j < len; ++j) {
                    ps.setObject(j + 1, ((Map)list.get(i)).get(fields[j]));
                }
            }

            public int getBatchSize() {
                return list.size();
            }
        });
    }

    public List<Long> batchAddWithId(@NotNull String tableName, String[] fields, List<Map<String, Object>> list) throws Exception {
        StringBuffer sql = new StringBuffer("insert into ").append(tableName).append("(").append(SqlBuilderUtils.buildFields(fields)).append(") values (").append(SqlBuilderUtils.buildQuestion(fields)).append(");");
        Connection con = this.getJdbcTemplate().getDataSource().getConnection();
        con.setAutoCommit(false);
        PreparedStatement pstmt = con.prepareStatement(sql.toString(), 1);
        for (Map<String, Object> map : list) {
            int len = fields.length;
            for (int j = 0; j < len; ++j) {
                pstmt.setObject(j + 1, map.get(fields[j]));
            }
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        con.commit();
        ResultSet rs = pstmt.getGeneratedKeys();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (rs.next()) {
            ids.add(rs.getLong(1));
        }
        con.close();
        pstmt.close();
        rs.close();
        return ids;
    }

    public int update(String sql, List<Object> params) {
        return this.getJdbcTemplate().update(sql, params.toArray());
    }

    public int update(@NotNull String tableName, Map<String, Object> map, LinkedHashMap<String, Object> whereMap) {
        Pair<String, Object[]> pair = SqlBuilderUtils.buildUpdateSql(tableName, map, whereMap);
        return this.getJdbcTemplate().update((String)pair.getKey(), (Object[])pair.getValue());
    }

    public Map<String, Object> findOne(@NotNull String sql) {
        return this.getJdbcTemplate().queryForMap(sql);
    }

    public Map<String, Object> findOne(@NotNull String sql, Object[] params) {
        return this.getJdbcTemplate().queryForMap(sql, params);
    }

    public Map<String, Object> findById(@NotNull String tableName, @NotNull String idFiledName, @NotNull String id) {
        return this.getJdbcTemplate().queryForMap("SELECT * FROM " + SqlBuilderUtils.buildTableName(tableName) + " WHERE " + NamingUtils.camelToUnderline((String)idFiledName) + " = ?", new Object[]{id});
    }

    public <T> T findById(@NotNull String tableName, @NotNull String idFiledName, @NotNull String id, Class<T> elementType) {
        Map<String, Object> queryResultMap = this.findById(tableName, idFiledName, id);
        return (T)BeanUtil.mapToBean(queryResultMap, elementType, (boolean)true);
    }

    public List<Map<String, Object>> queryForList(@NotNull String sql) {
        log.debug("queryForList\u67e5\u8be2\u8bed\u53e5\u4e3a\uff1a{}", (Object)sql);
        return this.getJdbcTemplate().queryForList(sql);
    }

    public List<Map<String, Object>> queryForList(@NotNull String sql, Object[] params) {
        log.debug("queryForList\u67e5\u8be2\u8bed\u53e5\u4e3a\uff1a{}", (Object)sql);
        return this.getJdbcTemplate().queryForList(sql, params);
    }

    public <T> List<T> queryForList(@NotNull String sql, Class<T> elementType) {
        ArrayList listResult = Lists.newArrayList();
        List<Map<String, Object>> listQueryResultMap = this.queryForList(sql);
        if (CollectionUtils.isEmpty(listQueryResultMap)) {
            return null;
        }
        listQueryResultMap.forEach(item -> listResult.add(BeanUtil.mapToBean((Map)item, (Class)elementType, (boolean)true)));
        return listResult;
    }

    public <T> List<T> queryForList(@NotNull String sql, Object[] params, Class<T> elementType) {
        ArrayList listResult = Lists.newArrayList();
        List<Map<String, Object>> listQueryResultMap = this.queryForList(sql, params);
        if (CollectionUtils.isEmpty(listQueryResultMap)) {
            return null;
        }
        listQueryResultMap.forEach(item -> listResult.add(BeanUtil.mapToBean((Map)item, (Class)elementType, (boolean)true)));
        return listResult;
    }

    public <T> List<T> queryForList(@NotNull String sql, Object[] params, BeanPropertyRowMapper<T> beanPropertyRowMapper) {
        List listResult = this.jdbcTemplate.query(sql, params, beanPropertyRowMapper);
        return listResult;
    }

    public Integer delete(@NotNull String tableName, @NotNull String idFiledName, @NotNull String id) {
        StringBuffer sql = new StringBuffer("DELETE FROM ").append(SqlBuilderUtils.buildTableName(tableName)).append(" WHERE " + idFiledName + "= ? ");
        return this.getJdbcTemplate().update(sql.toString(), new Object[]{id});
    }

    public long count(@NotNull String tableName, @NotNull String alias, Map<String, String> where) {
        String sql = SqlBuilderUtils.buildCountSql(tableName, alias, where);
        return (Long)this.getJdbcTemplate().queryForObject(sql, Long.class);
    }

    public long count(String tableName, Map<String, String> where) {
        return this.count(tableName, "1", where);
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcTemplateUtils)) {
            return false;
        }
        JdbcTemplateUtils other = (JdbcTemplateUtils)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        return !(this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcTemplateUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcTemplateUtils(jdbcTemplate=" + this.getJdbcTemplate() + ")";
    }
}

