package com.sinosoftgz.starter.jpa.domain;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Created by Roney on 2019/8/21.
 *
 * @author Roney
 * @date 2019-08-21 10:19
 */
@MappedSuperclass
public abstract class BaseDomain implements Serializable {

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private LocalDateTime createTime;

    /**
     * 更新者
     */
    @Column(name = "update_by")
    private String updateBy;

    /**
     * 更新时间
     */
    @Column(name = "update_time")
    private LocalDateTime updateTime;

    /**
     * 更新备注
     */
    @Column(name = "update_remark")
    private String updateRemark;

    /**
     * 版本
     */
    @Column(name = "version")
    private Integer version;

    /**
     * 删除标记
     */
    @Column(name = "delete_flag")
    private Boolean deleteFlag;

    /**
     * 删除时间
     */
    @Column(name = "delete_time")
    private LocalDateTime deleteTime;


    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateRemark() {
        return updateRemark;
    }

    public void setUpdateRemark(String updateRemark) {
        this.updateRemark = updateRemark;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Boolean getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Boolean deleteFlag) {

        if (deleteFlag != null && deleteFlag) {
            this.deleteTime = LocalDateTime.now();
        }
        this.deleteFlag = deleteFlag;
    }

    public LocalDateTime getDeleteTime() {
        return deleteTime;
    }

    public void setDeleteTime(LocalDateTime deleteDate) {
        this.deleteTime = deleteDate;
    }

    @PrePersist
    protected void prePersist() {
        createTime = LocalDateTime.now();
        updateTime = createTime;
        version = 1;
        deleteFlag = false;
    }

    @PreUpdate
    private void preUpdate() {
        updateTime = LocalDateTime.now();
        if (version == null) {
            version = 1;
        } else {
            version++;
        }
    }
}
