package com.sinosoftgz.starter.mybatisplus.config;


import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.sinosoftgz.starter.mybatisplus.handler.FillMetaObjectHandler;
import com.sinosoftgz.starter.mybatisplus.properties.MybatisPlusCustomProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * Created by Roney on 2019/8/16.
 *
 * @author Roney
 * @date 2019-08-16 15:18
 */

@Configuration
@EnableConfigurationProperties({MybatisPlusCustomProperties.class})
@Slf4j
public class MybatisPlusConfiguration {


    private final MybatisPlusCustomProperties properties;

    public MybatisPlusConfiguration(MybatisPlusCustomProperties properties) {
        this.properties = properties;
    }

    /**
     * 自动填充组件
     *
     * @return
     */
    @Bean
    public GlobalConfig globalConfig() {
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler(new FillMetaObjectHandler());
        return globalConfig;
    }

    /**
     * 注入FillMetaObjectHandler bean
     *
     * @return
     */
    @Bean
    public FillMetaObjectHandler fillMetaObjectHandler() {
        return new FillMetaObjectHandler();
    }


    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        /**
         * 乐观锁插件
         */
        interceptor.addInnerInterceptor(new OptimisticLockerInnerInterceptor());
        /**
         * 分页插件
         * 新的分页插件,一缓和二缓遵循mybatis的规则
         */
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor());

        /**
         * sql性能规范
         */
        enableIllegalSQL(interceptor);
        /**
         * 防止全表更新与删除
         */
        interceptor.addInnerInterceptor(new BlockAttackInnerInterceptor());
        return interceptor;
    }

    private void enableIllegalSQL(MybatisPlusInterceptor interceptor) {
        if (properties.getEnableIllegalSQL()) {
            /**
             * sql性能规范
             */
            interceptor.addInnerInterceptor(new IllegalSQLInnerInterceptor());
        }
    }


}
