package com.sinosoftgz.starter.mybatisplus.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.time.LocalDateTime;

/**
 * @author: Roney
 * @date: 2021-11-15 19:02
 * @description: 基础基类
 */
public abstract class AbstractBaseEntity {
    private static final long serialVersionUID = -1L;

    public static final String ID = "id";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_TIME = "create_time";
    public static final String DELETE_FLAG = "delete_flag";

    public static final String DELETE_TIME = "delete_time";

    public static final String UPDATE_REMARK = "update_remark";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_TIME = "update_time";

    public static final String VERSION = "version";

    public static final String ID_PROPERTY_NAME = "id";

    public static final String CREATE_BY_PROPERTY_NAME = "createBy";

    public static final String CREATE_TIME_PROPERTY_NAME = "createTime";

    public static final String DELETE_FLAG_PROPERTY_NAME = "deleteFlag";

    public static final String DELETE_TIME_PROPERTY_NAME = "deleteTime";

    public static final String UPDATE_REMARK_PROPERTY_NAME = "updateRemark";

    public static final String UPDATE_BY_PROPERTY_NAME = "updateBy";

    public static final String UPDATE_TIME_PROPERTY_NAME = "updateTime";

    public static final String VERSION_PROPERTY_NAME = "version";


    /**
     * 创建者
     */
    private String createBy;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;


    /**
     * 删除时间
     */
    protected LocalDateTime deleteTime;

    /**
     * 更新备注
     */
    private String updateRemark;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    /**
     * 版本
     */
    @Version
    private Integer version;

    @TableField(exist = false)
    public static String[] ignoreColumns = new String[]{ID, CREATE_BY, CREATE_TIME, DELETE_FLAG, DELETE_TIME, UPDATE_BY, UPDATE_TIME, UPDATE_REMARK, VERSION};


    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }


    public LocalDateTime getDeleteTime() {
        return deleteTime;
    }

    public void setDeleteTime(LocalDateTime deleteTime) {
        this.deleteTime = deleteTime;
    }

    public String getUpdateRemark() {
        return updateRemark;
    }

    public void setUpdateRemark(String updateRemark) {
        this.updateRemark = updateRemark;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }


}
